/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.consul.Coordinate;
import io.vertx.ext.consul.DcCoordinates;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class DcCoordinatesConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, DcCoordinates obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "datacenter": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatacenter((String)member.getValue());
                    break;
                }
                case "servers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Coordinate> list = new ArrayList<Coordinate>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Coordinate((JsonObject)item));
                        }
                    });
                    obj.setServers(list);
                }
            }
        }
    }

    static void toJson(DcCoordinates obj, JsonObject json) {
        DcCoordinatesConverter.toJson(obj, json.getMap());
    }

    static void toJson(DcCoordinates obj, Map<String, Object> json) {
        if (obj.getDatacenter() != null) {
            json.put("datacenter", obj.getDatacenter());
        }
        if (obj.getServers() != null) {
            JsonArray array = new JsonArray();
            obj.getServers().forEach(item -> array.add((Object)item.toJson()));
            json.put("servers", array);
        }
    }
}

