/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.WatchResult;
import io.vertx.ext.consul.impl.WatchImpl;

@VertxGen
public interface Watch<T> {
    public static Watch<KeyValue> key(String key, Vertx vertx) {
        return Watch.key(key, vertx, new ConsulClientOptions());
    }

    public static Watch<KeyValue> key(String key, Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.Key(key, vertx, options);
    }

    public static Watch<KeyValueList> keyPrefix(String keyPrefix, Vertx vertx) {
        return Watch.keyPrefix(keyPrefix, vertx, new ConsulClientOptions());
    }

    public static Watch<KeyValueList> keyPrefix(String keyPrefix, Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.KeyPrefix(keyPrefix, vertx, options);
    }

    public static Watch<ServiceList> services(Vertx vertx) {
        return Watch.services(vertx, new ConsulClientOptions());
    }

    public static Watch<ServiceList> services(Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.Services(vertx, options);
    }

    public static Watch<ServiceEntryList> service(String service, Vertx vertx) {
        return Watch.service(service, vertx, new ConsulClientOptions());
    }

    public static Watch<ServiceEntryList> service(String service, Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.Service(service, vertx, options);
    }

    public static Watch<EventList> events(String event, Vertx vertx) {
        return Watch.events(event, vertx, new ConsulClientOptions());
    }

    public static Watch<EventList> events(String event, Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.Events(event, vertx, options);
    }

    public static Watch<NodeList> nodes(Vertx vertx) {
        return new WatchImpl.Nodes(vertx, new ConsulClientOptions());
    }

    public static Watch<NodeList> nodes(Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.Nodes(vertx, options);
    }

    public static Watch<CheckList> nodeHealthChecks(String node, CheckQueryOptions opt, Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.NodeHealthCheck(node, opt, vertx, options);
    }

    public static Watch<CheckList> serviceHealthChecks(String service, CheckQueryOptions checkQueryOptions, Vertx vertx, ConsulClientOptions options) {
        return new WatchImpl.ServiceHealthCheck(service, checkQueryOptions, vertx, options);
    }

    @Fluent
    public Watch<T> setHandler(Handler<WatchResult<T>> var1);

    @Fluent
    public Watch<T> start();

    public void stop();
}

