/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.ClientHttpEndpointBase;
import io.vertx.core.http.impl.EndpointKey;
import io.vertx.core.http.impl.Http1xClientConnection;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.SharedClientHttpStreamEndpoint;
import io.vertx.core.http.impl.WebSocketEndpoint;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetClientImpl;
import io.vertx.core.net.impl.ProxyFilter;
import io.vertx.core.net.impl.pool.ConnectionManager;
import io.vertx.core.net.impl.pool.Endpoint;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HttpClientImpl
implements HttpClient,
MetricsProvider,
Closeable {
    private static final Pattern ABS_URI_START_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alpha}\\p{Digit}+.\\-]*:");
    private static final Function<HttpClientResponse, Future<RequestOptions>> DEFAULT_HANDLER = resp -> {
        try {
            int statusCode = resp.statusCode();
            String location = resp.getHeader(HttpHeaders.LOCATION);
            if (location != null && (statusCode == 301 || statusCode == 302 || statusCode == 303 || statusCode == 307 || statusCode == 308)) {
                String query;
                String requestURI;
                boolean ssl;
                HttpMethod m = resp.request().getMethod();
                if (statusCode == 303) {
                    m = HttpMethod.GET;
                } else if (m != HttpMethod.GET && m != HttpMethod.HEAD) {
                    return null;
                }
                URI uri = HttpUtils.resolveURIReference(resp.request().absoluteURI(), location);
                int port = uri.getPort();
                String protocol = uri.getScheme();
                char chend = protocol.charAt(protocol.length() - 1);
                if (chend == 'p') {
                    ssl = false;
                    if (port == -1) {
                        port = 80;
                    }
                } else if (chend == 's') {
                    ssl = true;
                    if (port == -1) {
                        port = 443;
                    }
                } else {
                    return null;
                }
                if ((requestURI = uri.getPath()) == null || requestURI.isEmpty()) {
                    requestURI = "/";
                }
                if ((query = uri.getQuery()) != null) {
                    requestURI = requestURI + "?" + query;
                }
                RequestOptions options = new RequestOptions();
                options.setMethod(m);
                options.setHost(uri.getHost());
                options.setPort(port);
                options.setSsl(ssl);
                options.setURI(requestURI);
                options.setHeaders(resp.request().headers());
                options.removeHeader(HttpHeaders.CONTENT_LENGTH);
                return Future.succeededFuture(options);
            }
            return null;
        }
        catch (Exception e) {
            return Future.failedFuture(e);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(HttpClientImpl.class);
    private static final Consumer<Endpoint<Lease<HttpClientConnection>>> EXPIRED_CHECKER = endpoint -> ((ClientHttpEndpointBase)endpoint).checkExpired();
    private final VertxInternal vertx;
    private final ChannelGroup channelGroup;
    private final HttpClientOptions options;
    private final ConnectionManager<EndpointKey, HttpClientConnection> webSocketCM;
    private final ConnectionManager<EndpointKey, Lease<HttpClientConnection>> httpCM;
    private final NetClientImpl netClient;
    private final HttpClientMetrics metrics;
    private final boolean keepAlive;
    private final boolean pipelining;
    private final CloseFuture closeFuture;
    private long timerID;
    private Predicate<SocketAddress> proxyFilter;
    private volatile Handler<HttpConnection> connectionHandler;
    private volatile Function<HttpClientResponse, Future<RequestOptions>> redirectHandler = DEFAULT_HANDLER;

    public HttpClientImpl(VertxInternal vertx, HttpClientOptions options, CloseFuture closeFuture) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI() != null ? vertx.metricsSPI().createHttpClientMetrics(options) : null;
        this.options = new HttpClientOptions(options);
        this.channelGroup = new DefaultChannelGroup((EventExecutor)vertx.getAcceptorEventLoopGroup().next());
        this.closeFuture = closeFuture;
        List<HttpVersion> alpnVersions = options.getAlpnVersions();
        if (alpnVersions == null || alpnVersions.isEmpty()) {
            switch (options.getProtocolVersion()) {
                case HTTP_2: {
                    alpnVersions = Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1);
                    break;
                }
                default: {
                    alpnVersions = Collections.singletonList(options.getProtocolVersion());
                }
            }
        }
        this.keepAlive = options.isKeepAlive();
        this.pipelining = options.isPipelining();
        if (!this.keepAlive && this.pipelining) {
            throw new IllegalStateException("Cannot have pipelining with no keep alive");
        }
        this.proxyFilter = options.getNonProxyHosts() != null ? ProxyFilter.nonProxyHosts(options.getNonProxyHosts()) : ProxyFilter.DEFAULT_PROXY_FILTER;
        this.netClient = new NetClientImpl(vertx, new NetClientOptions(options).setHostnameVerificationAlgorithm(options.isVerifyHost() ? "HTTPS" : "").setProxyOptions(null).setApplicationLayerProtocols(alpnVersions.stream().map(HttpVersion::alpnName).collect(Collectors.toList())), closeFuture);
        this.webSocketCM = this.webSocketConnectionManager();
        this.httpCM = this.httpConnectionManager();
        if (options.getPoolCleanerPeriod() > 0 && ((long)options.getKeepAliveTimeout() > 0L || (long)options.getHttp2KeepAliveTimeout() > 0L)) {
            PoolChecker checker = new PoolChecker(this);
            this.timerID = vertx.setTimer(options.getPoolCleanerPeriod(), checker);
        }
        closeFuture.add(this.netClient);
        closeFuture.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired(Handler<Long> checker) {
        this.httpCM.forEach(EXPIRED_CHECKER);
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (!this.closeFuture.isClosed()) {
                this.timerID = this.vertx.setTimer(this.options.getPoolCleanerPeriod(), checker);
            }
        }
    }

    private ConnectionManager<EndpointKey, Lease<HttpClientConnection>> httpConnectionManager() {
        int maxPoolSize = Math.max(this.options.getMaxPoolSize(), this.options.getHttp2MaxPoolSize());
        return new ConnectionManager<EndpointKey, Lease<HttpClientConnection>>((key, ctx, dispose) -> {
            ClientMetrics metrics = this.metrics != null ? this.metrics.createEndpointMetrics(key.serverAddr, maxPoolSize) : null;
            HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, key.proxyOptions, metrics, this.options.getProtocolVersion(), key.ssl, this.options.isUseAlpn(), key.peerAddr, key.serverAddr);
            return new SharedClientHttpStreamEndpoint(this, metrics, this.options.getMaxWaitQueueSize(), this.options.getMaxPoolSize(), this.options.getHttp2MaxPoolSize(), connector, dispose);
        });
    }

    private ConnectionManager<EndpointKey, HttpClientConnection> webSocketConnectionManager() {
        int maxPoolSize = this.options.getMaxWebSockets();
        return new ConnectionManager<EndpointKey, HttpClientConnection>((key, ctx, dispose) -> {
            ClientMetrics metrics = this.metrics != null ? this.metrics.createEndpointMetrics(key.serverAddr, maxPoolSize) : null;
            HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, key.proxyOptions, metrics, HttpVersion.HTTP_1_1, key.ssl, false, key.peerAddr, key.serverAddr);
            return new WebSocketEndpoint(null, maxPoolSize, connector, dispose);
        });
    }

    private int getPort(RequestOptions request) {
        Integer port = request.getPort();
        if (port != null) {
            return port;
        }
        SocketAddress server = request.getServer();
        if (server != null && server.isInetSocket()) {
            return server.port();
        }
        return this.options.getDefaultPort();
    }

    private ProxyOptions getProxyOptions(ProxyOptions proxyOptions) {
        if (proxyOptions == null) {
            proxyOptions = this.options.getProxyOptions();
        }
        return proxyOptions;
    }

    private String getHost(RequestOptions request) {
        String host = request.getHost();
        if (host != null) {
            return host;
        }
        SocketAddress server = request.getServer();
        if (server != null && server.isInetSocket()) {
            return server.host();
        }
        return this.options.getDefaultHost();
    }

    HttpClientMetrics metrics() {
        return this.metrics;
    }

    public Future<HttpClientConnection> connect(SocketAddress server) {
        return this.connect(server, null);
    }

    public Future<HttpClientConnection> connect(SocketAddress server, SocketAddress peer) {
        EventLoopContext context = (EventLoopContext)this.vertx.getOrCreateContext();
        HttpChannelConnector connector = new HttpChannelConnector(this, this.netClient, null, null, this.options.getProtocolVersion(), this.options.isSsl(), this.options.isUseAlpn(), peer, server);
        return connector.httpConnect(context);
    }

    @Override
    public void webSocket(WebSocketConnectOptions connectOptions, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(connectOptions, this.vertx.promise(handler));
    }

    private void webSocket(WebSocketConnectOptions connectOptions, PromiseInternal<WebSocket> promise) {
        ProxyOptions proxyOptions = this.getProxyOptions(connectOptions.getProxyOptions());
        int port = this.getPort(connectOptions);
        String host = this.getHost(connectOptions);
        SocketAddress addr = SocketAddress.inetSocketAddress(port, host);
        if (this.proxyFilter != null && !this.proxyFilter.test(addr)) {
            proxyOptions = null;
        }
        EndpointKey key = new EndpointKey(connectOptions.isSsl() != null ? connectOptions.isSsl().booleanValue() : this.options.isSsl(), proxyOptions, addr, addr);
        ContextInternal ctx = promise.context();
        EventLoopContext eventLoopContext = ctx instanceof EventLoopContext ? (EventLoopContext)ctx : this.vertx.createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        this.webSocketCM.getConnection(eventLoopContext, key, ar -> {
            if (ar.succeeded()) {
                Http1xClientConnection conn = (Http1xClientConnection)ar.result();
                conn.toWebSocket(ctx, connectOptions.getURI(), connectOptions.getHeaders(), connectOptions.getVersion(), connectOptions.getSubProtocols(), this.options.getMaxWebSocketFrameSize(), promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    @Override
    public Future<WebSocket> webSocket(int port, String host, String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(port, host, requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(String host, String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(host, requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(String requestURI) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(requestURI, promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocket(options, (Handler<AsyncResult<WebSocket>>)promise);
        return promise.future();
    }

    @Override
    public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        PromiseInternal<WebSocket> promise = this.vertx.promise();
        this.webSocketAbs(url, headers, version, subProtocols, promise);
        return promise.future();
    }

    @Override
    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port), handler);
    }

    @Override
    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.webSocket(this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("Scheme: " + scheme);
        }
        boolean ssl = scheme.length() == 3;
        int port = uri.getPort();
        if (port == -1) {
            port = ssl ? 443 : 80;
        }
        StringBuilder relativeUri = new StringBuilder();
        if (uri.getRawPath() != null) {
            relativeUri.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            relativeUri.append('?').append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            relativeUri.append('#').append(uri.getRawFragment());
        }
        WebSocketConnectOptions options = new WebSocketConnectOptions().setHost(uri.getHost()).setPort(port).setSsl(ssl).setURI(relativeUri.toString()).setHeaders(headers).setVersion(version).setSubProtocols(subProtocols);
        this.webSocket(options, handler);
    }

    @Override
    public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise(handler);
        this.doRequest(options, promise);
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal<HttpClientRequest> promise = ctx.promise();
        this.doRequest(options, promise);
        return promise.future();
    }

    @Override
    public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(new RequestOptions().setMethod(method).setPort(port).setHost(host).setURI(requestURI), handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        return this.request(new RequestOptions().setMethod(method).setPort(port).setHost(host).setURI(requestURI));
    }

    @Override
    public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(method, this.options.getDefaultPort(), host, requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), host, requestURI);
    }

    @Override
    public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
        return this.request(method, this.options.getDefaultPort(), this.options.getDefaultHost(), requestURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> completion) {
        HttpClientImpl httpClientImpl = this;
        synchronized (httpClientImpl) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.webSocketCM.close();
        this.httpCM.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
        completion.complete();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.netClient.close(handler);
    }

    @Override
    public Future<Void> close() {
        return this.netClient.close();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.getMetrics() != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        this.connectionHandler = handler;
        return this;
    }

    Handler<HttpConnection> connectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        if (handler == null) {
            handler = DEFAULT_HANDLER;
        }
        this.redirectHandler = handler;
        return this;
    }

    @Override
    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        return this.redirectHandler;
    }

    public HttpClient proxyFilter(Predicate<SocketAddress> filter) {
        this.proxyFilter = filter;
        return this;
    }

    public HttpClientOptions getOptions() {
        return this.options;
    }

    public VertxInternal getVertx() {
        return this.vertx;
    }

    private void doRequest(RequestOptions request, PromiseInternal<HttpClientRequest> promise) {
        String peerHost;
        boolean useSSL;
        String host = this.getHost(request);
        int port = this.getPort(request);
        SocketAddress server = request.getServer();
        if (server == null) {
            server = SocketAddress.inetSocketAddress(port, host);
        }
        ProxyOptions proxyOptions = this.getProxyOptions(request.getProxyOptions());
        HttpMethod method = request.getMethod();
        String requestURI = request.getURI();
        Boolean ssl = request.isSsl();
        MultiMap headers = request.getHeaders();
        long timeout = request.getTimeout();
        Boolean followRedirects = request.getFollowRedirects();
        Objects.requireNonNull(method, "no null method accepted");
        Objects.requireNonNull(host, "no null host accepted");
        Objects.requireNonNull(requestURI, "no null requestURI accepted");
        boolean useAlpn = this.options.isUseAlpn();
        boolean bl = useSSL = ssl != null ? ssl.booleanValue() : this.options.isSsl();
        if (!useAlpn && useSSL && this.options.getProtocolVersion() == HttpVersion.HTTP_2) {
            throw new IllegalArgumentException("Must enable ALPN when using H2");
        }
        this.checkClosed();
        if (this.proxyFilter != null && !this.proxyFilter.test(server)) {
            proxyOptions = null;
        }
        if (proxyOptions != null && !useSSL && proxyOptions.getType() == ProxyType.HTTP) {
            if (!ABS_URI_START_PATTERN.matcher(requestURI).find()) {
                int defaultPort = 80;
                String addPort = port != -1 && port != defaultPort ? ":" + port : "";
                requestURI = (ssl == Boolean.TRUE ? "https://" : "http://") + host + addPort + requestURI;
            }
            if (proxyOptions.getUsername() != null && proxyOptions.getPassword() != null) {
                if (headers == null) {
                    headers = HttpHeaders.headers();
                }
                headers.add("Proxy-Authorization", "Basic " + Base64.getEncoder().encodeToString((proxyOptions.getUsername() + ":" + proxyOptions.getPassword()).getBytes()));
            }
            server = SocketAddress.inetSocketAddress(proxyOptions.getPort(), proxyOptions.getHost());
            proxyOptions = null;
        }
        if ((peerHost = host).endsWith(".")) {
            peerHost = peerHost.substring(0, peerHost.length() - 1);
        }
        SocketAddress peerAddress = SocketAddress.inetSocketAddress(port, peerHost);
        this.doRequest(method, peerAddress, server, host, port, useSSL, requestURI, headers, timeout, followRedirects, proxyOptions, promise);
    }

    private void doRequest(HttpMethod method, SocketAddress peerAddress, SocketAddress server, String host, int port, Boolean useSSL, String requestURI, MultiMap headers, long timeout, Boolean followRedirects, ProxyOptions proxyOptions, PromiseInternal<HttpClientRequest> requestPromise) {
        ContextInternal ctx = requestPromise.context();
        EndpointKey key = new EndpointKey(useSSL, proxyOptions, server, peerAddress);
        EventLoopContext eventLoopContext = ctx instanceof EventLoopContext ? (EventLoopContext)ctx : this.vertx.createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        this.httpCM.getConnection(eventLoopContext, key, timeout, ar1 -> {
            if (ar1.succeeded()) {
                Lease lease = (Lease)ar1.result();
                HttpClientConnection conn = (HttpClientConnection)lease.get();
                conn.createStream(ctx, ar2 -> {
                    if (ar2.succeeded()) {
                        HttpClientStream stream = (HttpClientStream)ar2.result();
                        stream.closeHandler(v -> lease.recycle());
                        HttpClientRequestImpl req = new HttpClientRequestImpl(this, stream, ctx.promise(), useSSL, method, server, host, port, requestURI);
                        if (headers != null) {
                            req.headers().setAll(headers);
                        }
                        if (followRedirects != null) {
                            req.setFollowRedirects(followRedirects);
                        }
                        if (timeout > 0L) {
                            req.setTimeout(timeout);
                        }
                        requestPromise.complete(req);
                    } else {
                        requestPromise.tryFail(ar2.cause());
                    }
                });
            } else {
                requestPromise.tryFail(ar1.cause());
            }
        });
    }

    private void checkClosed() {
        if (this.closeFuture.isClosed()) {
            throw new IllegalStateException("Client is closed");
        }
    }

    protected void finalize() throws Throwable {
        this.close((Handler<AsyncResult<Void>>)Promise.promise());
        super.finalize();
    }

    private static class PoolChecker
    implements Handler<Long> {
        final WeakReference<HttpClientImpl> ref;

        private PoolChecker(HttpClientImpl client) {
            this.ref = new WeakReference<HttpClientImpl>(client);
        }

        @Override
        public void handle(Long event) {
            HttpClientImpl client = (HttpClientImpl)this.ref.get();
            if (client != null) {
                client.checkExpired(this);
            }
        }
    }
}

