/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPResponse;
import io.vertx.ext.mail.mailencoder.EmailAddress;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class SMTPSendMail {
    private static final Logger log = LoggerFactory.getLogger(SMTPSendMail.class);
    private static final Pattern linePattern = Pattern.compile("\r\n");
    private final SMTPConnection connection;
    private final MailMessage email;
    private final MailConfig config;
    private final MailResult mailResult;
    private final EncodedPart encodedPart;
    private final AtomicLong written = new AtomicLong();

    SMTPSendMail(SMTPConnection connection, MailMessage email, MailConfig config, EncodedPart encodedPart, String messageId) {
        this.connection = connection;
        this.email = email;
        this.config = config;
        this.mailResult = new MailResult();
        this.encodedPart = encodedPart;
        this.mailResult.setMessageID(messageId);
    }

    void startMailTransaction(Handler<AsyncResult<MailResult>> resultHandler) {
        this.sendMailEvenlope().flatMap(this::sendMailData).onComplete(resultHandler);
    }

    private boolean checkSize() {
        int size = this.connection.getCapa().getSize();
        return size == 0 || size >= this.encodedPart.size();
    }

    private String mailFromAddress() {
        String bounceAddr = this.email.getBounceAddress();
        String fromAddr = bounceAddr != null && !bounceAddr.isEmpty() ? bounceAddr : this.email.getFrom();
        EmailAddress from = new EmailAddress(fromAddr);
        return from.getEmail();
    }

    private String sizeParameter() {
        String sizeParameter = this.connection.getCapa().getSize() > 0 ? " SIZE=" + this.encodedPart.size() : "";
        return sizeParameter;
    }

    private List<String> allRecipients() {
        ArrayList<String> recipientAddrs = new ArrayList<String>();
        if (this.email.getTo() != null) {
            recipientAddrs.addAll(this.email.getTo());
        }
        if (this.email.getCc() != null) {
            recipientAddrs.addAll(this.email.getCc());
        }
        if (this.email.getBcc() != null) {
            recipientAddrs.addAll(this.email.getBcc());
        }
        return recipientAddrs.stream().map(r -> {
            String email = "postmaster".equalsIgnoreCase((String)r) ? r : new EmailAddress((String)r).getEmail();
            return email;
        }).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Future<Boolean> sendMailEvenlope() {
        Promise evenlopePromise = Promise.promise();
        try {
            if (!this.checkSize()) {
                evenlopePromise.fail("message exceeds allowed size limit");
                return evenlopePromise.future();
            }
            String mailFromLine = "MAIL FROM:<" + this.mailFromAddress() + ">" + this.sizeParameter();
            List<String> allRecipients = this.allRecipients();
            if (this.config.isPipelining() && this.connection.getCapa().isCapaPipelining()) {
                ArrayList<String> groupCommands = new ArrayList<String>();
                groupCommands.add(mailFromLine);
                groupCommands.addAll(allRecipients.stream().map(r -> "RCPT TO:<" + r + ">").collect(Collectors.toList()));
                groupCommands.add("DATA");
                this.connection.writeCommands(groupCommands, (Handler<String>)((Handler)evenlopeResultStr -> {
                    String[] evenlopeResult = linePattern.split((CharSequence)evenlopeResultStr);
                    if (groupCommands.size() != evenlopeResult.length) {
                        evenlopePromise.fail("Sent " + groupCommands.size() + " commands, but got " + evenlopeResult.length + " responses.");
                    } else {
                        for (int i = 0; i < evenlopeResult.length; ++i) {
                            String message = evenlopeResult[i];
                            SMTPResponse response = new SMTPResponse(message);
                            if (i == 0) {
                                if (response.isStatusOk()) continue;
                                evenlopePromise.fail((Throwable)((Object)response.toException("sender address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                                return;
                            }
                            if (i < evenlopeResult.length - 1) {
                                if (response.isStatusOk()) {
                                    this.mailResult.getRecipients().add((String)allRecipients.get(i - 1));
                                    continue;
                                }
                                if (this.config.isAllowRcptErrors()) continue;
                                evenlopePromise.fail((Throwable)((Object)response.toException("recipient address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                                return;
                            }
                            if (response.isStatusOk()) {
                                if (this.mailResult.getRecipients().size() != 0) continue;
                                evenlopePromise.complete((Object)false);
                                return;
                            }
                            evenlopePromise.fail((Throwable)((Object)response.toException("DATA command not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                            return;
                        }
                        evenlopePromise.complete((Object)true);
                    }
                }));
                return evenlopePromise.future();
            }
            Future future = this.sendMailFrom(mailFromLine);
            Iterator<String> iterator = allRecipients.iterator();
            while (iterator.hasNext()) {
                String email = iterator.next();
                future = future.flatMap(v -> this.sendRcptTo(email));
            }
            return future.flatMap(v -> this.sendDataCmd());
        }
        catch (Exception e) {
            evenlopePromise.fail((Throwable)e);
        }
        return evenlopePromise.future();
    }

    private Future<Void> sendMailFrom(String mailFromLine) {
        Promise promise = Promise.promise();
        this.connection.write(mailFromLine, (Handler<String>)((Handler)message -> {
            SMTPResponse response;
            if (log.isDebugEnabled()) {
                this.written.getAndAdd(mailFromLine.length());
            }
            if ((response = new SMTPResponse((String)message)).isStatusOk()) {
                promise.complete();
            } else {
                promise.fail((Throwable)((Object)response.toException("sender address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
            }
        }));
        return promise.future();
    }

    private Future<Void> sendRcptTo(String email) {
        Promise promise = Promise.promise();
        try {
            String line = "RCPT TO:<" + email + ">";
            this.connection.write(line, (Handler<String>)((Handler)message -> {
                if (log.isDebugEnabled()) {
                    this.written.getAndAdd(line.length());
                }
                try {
                    SMTPResponse response = new SMTPResponse((String)message);
                    if (response.isStatusOk()) {
                        this.mailResult.getRecipients().add(email);
                        promise.complete();
                    } else if (this.config.isAllowRcptErrors()) {
                        promise.complete();
                    } else {
                        promise.fail((Throwable)((Object)response.toException("recipient address not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                    }
                }
                catch (Exception e) {
                    promise.fail((Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<Boolean> sendDataCmd() {
        Promise promise = Promise.promise();
        try {
            if (this.mailResult.getRecipients().size() > 0) {
                this.connection.write("DATA", (Handler<String>)((Handler)message -> {
                    SMTPResponse response;
                    if (log.isDebugEnabled()) {
                        this.written.getAndAdd(4L);
                    }
                    if ((response = new SMTPResponse((String)message)).isStatusOk()) {
                        promise.complete((Object)true);
                    } else {
                        promise.fail((Throwable)((Object)response.toException("DATA command not accepted", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                    }
                }));
            } else {
                promise.fail("no recipient addresses were accepted, not sending mail");
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<MailResult> sendMailData(boolean includeData) {
        if (!includeData) {
            return this.sendEndDot();
        }
        return this.sendMailHeaders(this.encodedPart.headers()).flatMap(v -> this.sendMailBody()).flatMap(v -> this.sendEndDot());
    }

    private Future<Void> sendMailHeaders(MultiMap headers) {
        Promise promise = Promise.promise();
        try {
            StringBuilder sb = new StringBuilder();
            headers.forEach(header -> sb.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\r\n"));
            String headerLines = sb.toString();
            this.connection.writeLineWithDrainPromise(headerLines, this.written.getAndAdd(headerLines.length()) < 1000L, (Promise<Void>)promise);
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<MailResult> sendEndDot() {
        Promise promise = Promise.promise();
        try {
            this.connection.getContext().runOnContext(v -> this.connection.write(".", (Handler<String>)((Handler)msg -> {
                SMTPResponse response = new SMTPResponse((String)msg);
                if (response.isStatusOk()) {
                    promise.complete((Object)this.mailResult);
                } else {
                    promise.fail((Throwable)((Object)response.toException("sending data failed", this.connection.getCapa().isCapaEnhancedStatusCodes())));
                }
            })));
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private Future<Void> sendMailBody() {
        Promise promise = Promise.promise();
        EncodedPart part = this.encodedPart;
        try {
            if (this.isMultiPart(part)) {
                this.sendMultiPart(part, 0, (Promise<Void>)promise);
            } else {
                this.sendRegularPartBody(part, (Promise<Void>)promise);
            }
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
        return promise.future();
    }

    private void sendMultiPart(EncodedPart multiPart, int i, Promise<Void> promise) {
        try {
            String boundaryStart = "--" + multiPart.boundary();
            EncodedPart thePart = multiPart.parts().get(i);
            Promise boundaryStartPromise = Promise.promise();
            boundaryStartPromise.future().compose(v -> this.sendMailHeaders(thePart.headers())).onComplete(v -> {
                if (v.succeeded()) {
                    Promise nextPromise = Promise.promise();
                    nextPromise.future().onComplete(vv -> {
                        if (vv.succeeded()) {
                            if (i == multiPart.parts().size() - 1) {
                                String boundaryEnd;
                                this.connection.writeLineWithDrainPromise(boundaryEnd, this.written.getAndAdd((boundaryEnd = boundaryStart + "--").length()) < 1000L, promise);
                            } else {
                                this.sendMultiPart(multiPart, i + 1, promise);
                            }
                        } else {
                            promise.fail(vv.cause());
                        }
                    });
                    if (this.isMultiPart(thePart)) {
                        this.sendMultiPart(thePart, 0, (Promise<Void>)nextPromise);
                    } else {
                        this.sendRegularPartBody(thePart, (Promise<Void>)nextPromise);
                    }
                } else {
                    promise.fail(v.cause());
                }
            });
            this.connection.writeLineWithDrainPromise(boundaryStart, this.written.getAndAdd(boundaryStart.length()) < 1000L, (Promise<Void>)boundaryStartPromise);
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
    }

    private boolean isMultiPart(EncodedPart part) {
        return part.parts() != null && part.parts().size() > 0;
    }

    private void sendBodyLineByLine(String[] lines, int i, Promise<Void> promise) {
        if (i < lines.length) {
            String line = lines[i];
            if (line.startsWith(".")) {
                line = "." + line;
            }
            Promise writeLinePromise = Promise.promise();
            this.connection.writeLineWithDrainPromise(line, this.written.getAndAdd(line.length()) < 1000L, (Promise<Void>)writeLinePromise);
            writeLinePromise.future().onComplete(v -> {
                if (v.succeeded()) {
                    this.sendBodyLineByLine(lines, i + 1, promise);
                } else {
                    promise.fail(v.cause());
                }
            });
        } else {
            promise.complete();
        }
    }

    private void sendRegularPartBody(EncodedPart part, Promise<Void> promise) {
        if (part.body() != null) {
            this.sendBodyLineByLine(part.body().split("\n"), 0, promise);
        } else {
            ReadStream<Buffer> attachBodyStream = part.bodyStream(this.connection.getContext());
            if (attachBodyStream != null) {
                attachBodyStream.pipe().endOnComplete(false).to((WriteStream)this.connection.getSocket(), promise);
            } else {
                promise.fail((Throwable)new IllegalStateException("No mail body and stream found"));
            }
        }
    }
}

