/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.micrometer.jmx.JmxConfig;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.VertxJmxMetricsOptionsConverter;
import java.time.Duration;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class VertxJmxMetricsOptions {
    public static final boolean DEFAULT_ENABLED = false;
    public static final String DEFAULT_DOMAIN = "metrics";
    public static final int DEFAULT_STEP = 10;
    private boolean enabled;
    private String domain;
    private int step;

    public VertxJmxMetricsOptions() {
        this.enabled = false;
        this.domain = DEFAULT_DOMAIN;
        this.step = 10;
    }

    public VertxJmxMetricsOptions(VertxJmxMetricsOptions other) {
        this.enabled = other.enabled;
        this.domain = other.domain;
        this.step = other.step;
    }

    public VertxJmxMetricsOptions(JsonObject json) {
        this();
        VertxJmxMetricsOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        VertxJmxMetricsOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public VertxJmxMetricsOptions setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public VertxJmxMetricsOptions setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public int getStep() {
        return this.step;
    }

    public VertxJmxMetricsOptions setStep(int step) {
        this.step = step;
        return this;
    }

    public JmxConfig toMicrometerConfig() {
        return new JmxConfig(){

            public String get(String s) {
                return null;
            }

            public String domain() {
                return VertxJmxMetricsOptions.this.domain;
            }

            public Duration step() {
                return Duration.ofSeconds(VertxJmxMetricsOptions.this.step);
            }
        };
    }
}

