/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.meters.TagsCache;
import java.util.concurrent.TimeUnit;

public class Timers {
    private final String name;
    private final String description;
    private final Label[] keys;
    private final MeterRegistry registry;

    public Timers(String name, String description, MeterRegistry registry, Label ... keys) {
        this.name = name;
        this.description = description;
        this.registry = registry;
        this.keys = keys;
    }

    public Timer get(String ... values) {
        return this.get((Iterable<Tag>)null, values);
    }

    public Timer get(Iterable<Tag> customTags, String ... values) {
        Tags tags = TagsCache.getOrCreate(customTags, this.keys, values);
        return Timer.builder((String)this.name).description(this.description).tags((Iterable)tags).register(this.registry);
    }

    public EventTiming start() {
        return new EventTiming(this);
    }

    public static class EventTiming {
        private final Timers ref;
        private final long nanoStart;

        private EventTiming(Timers ref) {
            this.ref = ref;
            this.nanoStart = System.nanoTime();
        }

        public void end(String ... values) {
            this.end((Iterable<Tag>)null, values);
        }

        public void end(Iterable<Tag> customTags, String ... values) {
            Timer t = this.ref.get(customTags, values);
            t.record(System.nanoTime() - this.nanoStart, TimeUnit.NANOSECONDS);
        }
    }
}

