/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.impl.ForwardedParser;
import io.vertx.ext.web.impl.ServerWebSocketWrapper;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class HttpServerRequestWrapper
implements HttpServerRequestInternal {
    private final HttpServerRequestInternal delegate;
    private final ForwardedParser forwardedParser;
    private boolean modified;
    private HttpMethod method;
    private String path;
    private String query;
    private String uri;
    private String absoluteURI;
    private MultiMap params;

    HttpServerRequestWrapper(HttpServerRequest request, AllowForwardHeaders allowForward) {
        this.delegate = (HttpServerRequestInternal)request;
        this.forwardedParser = new ForwardedParser((HttpServerRequest)this.delegate, allowForward);
    }

    void changeTo(HttpMethod method, String uri) {
        this.modified = true;
        this.method = method;
        this.uri = uri;
        this.path = null;
        this.query = null;
        this.absoluteURI = null;
        int queryIndex = uri.indexOf(63);
        if (queryIndex != -1) {
            int fragmentIndex = uri.indexOf(35, queryIndex);
            this.path = uri.substring(0, queryIndex);
            this.query = fragmentIndex != -1 ? uri.substring(queryIndex + 1, fragmentIndex) : uri.substring(queryIndex + 1);
        } else {
            int fragmentIndex = uri.indexOf(35);
            this.path = fragmentIndex != -1 ? uri.substring(0, fragmentIndex) : uri;
        }
    }

    public HttpServerRequest body(Handler<AsyncResult<Buffer>> handler) {
        this.delegate.body(handler);
        return this;
    }

    public Future<Buffer> body() {
        return this.delegate.body();
    }

    public long bytesRead() {
        return this.delegate.bytesRead();
    }

    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public HttpVersion version() {
        return this.delegate.version();
    }

    public HttpMethod method() {
        if (!this.modified) {
            return this.delegate.method();
        }
        return this.method;
    }

    public String uri() {
        if (!this.modified) {
            return this.delegate.uri();
        }
        return this.uri;
    }

    public String path() {
        if (!this.modified) {
            return this.delegate.path();
        }
        return this.path;
    }

    public String query() {
        if (!this.modified) {
            return this.delegate.query();
        }
        return this.query;
    }

    public MultiMap params() {
        if (!this.modified) {
            return this.delegate.params();
        }
        if (this.params == null) {
            QueryStringDecoder queryStringDecoder;
            Map prms;
            this.params = MultiMap.caseInsensitiveMultiMap();
            if (this.query != null && !(prms = (queryStringDecoder = new QueryStringDecoder(this.uri)).parameters()).isEmpty()) {
                for (Map.Entry entry : prms.entrySet()) {
                    this.params.add((String)entry.getKey(), (Iterable)entry.getValue());
                }
            }
        }
        return this.params;
    }

    public String getParam(String param) {
        if (!this.modified) {
            return this.delegate.getParam(param);
        }
        return this.params().get(param);
    }

    public HttpServerResponse response() {
        return this.delegate.response();
    }

    public MultiMap headers() {
        return this.delegate.headers();
    }

    public String getHeader(String s) {
        return this.delegate.getHeader(s);
    }

    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    public SocketAddress remoteAddress() {
        return this.forwardedParser.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    public String absoluteURI() {
        if (!this.modified) {
            return this.forwardedParser.absoluteURI();
        }
        if (this.absoluteURI == null) {
            String scheme = this.forwardedParser.scheme();
            String host = this.forwardedParser.host();
            this.absoluteURI = scheme != null && host != null ? scheme + "://" + host + this.uri : this.uri;
        }
        return this.absoluteURI;
    }

    public String scheme() {
        return this.forwardedParser.scheme();
    }

    public String host() {
        return this.forwardedParser.host();
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    public HttpConnection connection() {
        return this.delegate.connection();
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        return this;
    }

    public void toNetSocket(Handler<AsyncResult<NetSocket>> handler) {
        this.delegate.toNetSocket(handler);
    }

    public Future<NetSocket> toNetSocket() {
        return this.delegate.toNetSocket();
    }

    public HttpServerRequest setExpectMultipart(boolean b) {
        this.delegate.setExpectMultipart(b);
        return this;
    }

    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        return this;
    }

    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    public String getFormAttribute(String s) {
        return this.delegate.getFormAttribute(s);
    }

    public int streamId() {
        return this.delegate.streamId();
    }

    public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        this.delegate.toWebSocket(toWebSocket -> {
            if (toWebSocket.succeeded()) {
                handler.handle((Object)Future.succeededFuture((Object)new ServerWebSocketWrapper((ServerWebSocket)toWebSocket.result(), this.host(), this.scheme(), this.isSSL(), this.remoteAddress())));
            } else {
                handler.handle(toWebSocket);
            }
        });
    }

    public Future<ServerWebSocket> toWebSocket() {
        return this.delegate.toWebSocket().map(ws -> new ServerWebSocketWrapper((ServerWebSocket)ws, this.host(), this.scheme(), this.isSSL(), this.remoteAddress()));
    }

    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    public boolean isSSL() {
        return this.forwardedParser.isSSL();
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public StreamPriority streamPriority() {
        return this.delegate.streamPriority();
    }

    public @Nullable Cookie getCookie(String name) {
        return this.delegate.getCookie(name);
    }

    public int cookieCount() {
        return this.delegate.cookieCount();
    }

    public Map<String, Cookie> cookieMap() {
        return this.delegate.cookieMap();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public Future<Void> end() {
        return this.delegate.end();
    }

    public HttpServerRequest routed(String route) {
        this.delegate.routed(route);
        return this;
    }

    public Context context() {
        return this.delegate.context();
    }

    public Object metric() {
        return this.delegate.metric();
    }

    public Pipe<Buffer> pipe() {
        return this.delegate.pipe();
    }

    public Future<Void> pipeTo(WriteStream<Buffer> dst) {
        return this.delegate.pipeTo(dst);
    }

    public void pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst, handler);
    }
}

