/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.batch.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.batch.model.BatchDeleteResponse;
import io.weaviate.client.v1.batch.util.ObjectsPath;
import io.weaviate.client.v1.filters.WhereFilter;
import lombok.Generated;

public class ObjectsBatchDeleter
extends BaseClient<BatchDeleteResponse>
implements ClientResult<BatchDeleteResponse> {
    private final ObjectsPath objectsPath;
    private String className;
    private String consistencyLevel;
    private String tenant;
    private WhereFilter where;
    private String output;
    private Boolean dryRun;

    public ObjectsBatchDeleter(HttpClient httpClient, Config config, ObjectsPath objectsPath) {
        super(httpClient, config);
        this.objectsPath = objectsPath;
    }

    public ObjectsBatchDeleter withClassName(String className) {
        this.className = className;
        return this;
    }

    public ObjectsBatchDeleter withConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ObjectsBatchDeleter withTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public ObjectsBatchDeleter withWhere(WhereFilter where) {
        this.where = where;
        return this;
    }

    public ObjectsBatchDeleter withOutput(String output) {
        this.output = output;
        return this;
    }

    public ObjectsBatchDeleter withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @Override
    public Result<BatchDeleteResponse> run() {
        BatchDeleteMatch match = BatchDeleteMatch.builder().className(this.className).whereFilter(this.where).build();
        BatchDelete batchDelete = BatchDelete.builder().dryRun(this.dryRun).output(this.output).match(match).build();
        String path = this.objectsPath.buildDelete(ObjectsPath.Params.builder().consistencyLevel(this.consistencyLevel).tenant(this.tenant).build());
        Response<BatchDeleteResponse> resp = this.sendDeleteRequest(path, batchDelete, BatchDeleteResponse.class);
        return new Result<BatchDeleteResponse>(resp);
    }

    public static class BatchDeleteMatch {
        @SerializedName(value="class")
        String className;
        @SerializedName(value="where")
        WhereFilter whereFilter;

        @Generated
        BatchDeleteMatch(String className, WhereFilter whereFilter) {
            this.className = className;
            this.whereFilter = whereFilter;
        }

        @Generated
        public static BatchDeleteMatchBuilder builder() {
            return new BatchDeleteMatchBuilder();
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public WhereFilter getWhereFilter() {
            return this.whereFilter;
        }

        @Generated
        public static class BatchDeleteMatchBuilder {
            @Generated
            private String className;
            @Generated
            private WhereFilter whereFilter;

            @Generated
            BatchDeleteMatchBuilder() {
            }

            @Generated
            public BatchDeleteMatchBuilder className(String className) {
                this.className = className;
                return this;
            }

            @Generated
            public BatchDeleteMatchBuilder whereFilter(WhereFilter whereFilter) {
                this.whereFilter = whereFilter;
                return this;
            }

            @Generated
            public BatchDeleteMatch build() {
                return new BatchDeleteMatch(this.className, this.whereFilter);
            }

            @Generated
            public String toString() {
                return "ObjectsBatchDeleter.BatchDeleteMatch.BatchDeleteMatchBuilder(className=" + this.className + ", whereFilter=" + this.whereFilter + ")";
            }
        }
    }

    public static class BatchDelete {
        BatchDeleteMatch match;
        String output;
        Boolean dryRun;

        @Generated
        BatchDelete(BatchDeleteMatch match, String output, Boolean dryRun) {
            this.match = match;
            this.output = output;
            this.dryRun = dryRun;
        }

        @Generated
        public static BatchDeleteBuilder builder() {
            return new BatchDeleteBuilder();
        }

        @Generated
        public BatchDeleteMatch getMatch() {
            return this.match;
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public Boolean getDryRun() {
            return this.dryRun;
        }

        @Generated
        public static class BatchDeleteBuilder {
            @Generated
            private BatchDeleteMatch match;
            @Generated
            private String output;
            @Generated
            private Boolean dryRun;

            @Generated
            BatchDeleteBuilder() {
            }

            @Generated
            public BatchDeleteBuilder match(BatchDeleteMatch match) {
                this.match = match;
                return this;
            }

            @Generated
            public BatchDeleteBuilder output(String output) {
                this.output = output;
                return this;
            }

            @Generated
            public BatchDeleteBuilder dryRun(Boolean dryRun) {
                this.dryRun = dryRun;
                return this;
            }

            @Generated
            public BatchDelete build() {
                return new BatchDelete(this.match, this.output, this.dryRun);
            }

            @Generated
            public String toString() {
                return "ObjectsBatchDeleter.BatchDelete.BatchDeleteBuilder(match=" + this.match + ", output=" + this.output + ", dryRun=" + this.dryRun + ")";
            }
        }
    }
}

