/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.users.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class RoleRevoker
extends BaseClient<Void>
implements ClientResult<Boolean> {
    private String userId;
    private List<String> roles = new ArrayList<String>();
    private final String _userType;

    public RoleRevoker(HttpClient httpClient, Config config) {
        this(httpClient, config, null);
    }

    public RoleRevoker(HttpClient httpClient, Config config, String userType) {
        super(httpClient, config);
        this._userType = userType;
    }

    public RoleRevoker withUserId(String id) {
        this.userId = id;
        return this;
    }

    public RoleRevoker witRoles(String ... roles) {
        this.roles = Collections.unmodifiableList(Arrays.asList(roles));
        return this;
    }

    @Override
    public Result<Boolean> run() {
        return Result.voidToBoolean(this.sendPostRequest(this.path(), new Body(this.roles), Void.class));
    }

    private String path() {
        return String.format("/authz/users/%s/revoke", this.userId);
    }

    private class Body {
        final String userType;
        final List<String> roles;

        @Generated
        public Body(List<String> roles) {
            this.userType = RoleRevoker.this._userType;
            this.roles = roles;
        }
    }
}

