/*
 * Decompiled with CFR 0.152.
 */
package brave.dubbo;

import brave.Span;
import brave.dubbo.DubboParser;
import brave.dubbo.DubboRequest;
import brave.rpc.RpcClientRequest;
import java.util.Map;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;

final class DubboClientRequest
extends RpcClientRequest
implements DubboRequest {
    final Invoker<?> invoker;
    final Invocation invocation;
    final Map<String, String> attachments;

    DubboClientRequest(Invoker<?> invoker, Invocation invocation, Map<String, String> attachments) {
        if (invoker == null) {
            throw new NullPointerException("invoker == null");
        }
        if (invocation == null) {
            throw new NullPointerException("invocation == null");
        }
        this.invoker = invoker;
        this.invocation = invocation;
        this.attachments = attachments;
    }

    @Override
    public Invoker<?> invoker() {
        return this.invoker;
    }

    @Override
    public Invocation invocation() {
        return this.invocation;
    }

    public Invocation unwrap() {
        return this.invocation;
    }

    public String method() {
        return DubboParser.method(this.invocation);
    }

    public String service() {
        return DubboParser.service(this.invoker);
    }

    public boolean parseRemoteIpAndPort(Span span) {
        return DubboParser.parseRemoteIpAndPort(span);
    }

    protected void propagationField(String keyName, String value) {
        this.attachments.put(keyName, value);
    }
}

