/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.Span;
import brave.Tracer;
import brave.grpc.GrpcPropagation;
import brave.grpc.GrpcServerParser;
import brave.grpc.GrpcTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;

final class TracingServerInterceptor
implements ServerInterceptor {
    static final Propagation.Getter<Metadata, Metadata.Key<String>> GETTER = new Propagation.Getter<Metadata, Metadata.Key<String>>(){

        public String get(Metadata metadata, Metadata.Key<String> key) {
            return (String)metadata.get(key);
        }

        public String toString() {
            return "Metadata::get";
        }
    };
    final Tracer tracer;
    final TraceContext.Extractor<Metadata> extractor;
    final GrpcServerParser parser;
    final boolean grpcPropagationFormatEnabled;

    TracingServerInterceptor(GrpcTracing grpcTracing) {
        this.tracer = grpcTracing.tracing.tracer();
        this.extractor = grpcTracing.propagation.extractor(GETTER);
        this.parser = grpcTracing.serverParser;
        this.grpcPropagationFormatEnabled = grpcTracing.grpcPropagationFormatEnabled;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        ServerCall.Listener result;
        GrpcPropagation.Tags tags;
        Span span;
        TraceContextOrSamplingFlags extracted = this.extractor.extract((Object)headers);
        Span span2 = span = extracted.context() != null ? this.tracer.joinSpan(extracted.context()) : this.tracer.nextSpan(extracted);
        if (this.grpcPropagationFormatEnabled && (tags = GrpcPropagation.findTags(span.context())) != null) {
            tags.put("method", call.getMethodDescriptor().getFullMethodName());
        }
        span.kind(Span.Kind.SERVER);
        this.parser.onStart(call, headers, span.customizer());
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);){
            result = next.startCall(new TracingServerCall<ReqT, RespT>(span, call, this.parser), headers);
        }
        catch (Error | RuntimeException e) {
            span.error(e);
            span.finish();
            throw e;
        }
        return new ScopingServerCallListener(this.tracer, span, result, this.parser);
    }

    static final class ScopingServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        final Tracer tracer;
        final Span span;
        final GrpcServerParser parser;

        ScopingServerCallListener(Tracer tracer, Span span, ServerCall.Listener<ReqT> delegate, GrpcServerParser parser) {
            super(delegate);
            this.tracer = tracer;
            this.span = span;
            this.parser = parser;
        }

        public void onMessage(ReqT message) {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
                this.parser.onMessageReceived(message, this.span.customizer());
                this.delegate().onMessage(message);
            }
        }

        public void onHalfClose() {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
                this.delegate().onHalfClose();
            }
        }

        public void onCancel() {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
                this.delegate().onCancel();
            }
        }

        public void onComplete() {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
                this.delegate().onComplete();
            }
        }

        public void onReady() {
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
                this.delegate().onReady();
            }
        }
    }

    static final class TracingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        final Span span;
        final GrpcServerParser parser;

        TracingServerCall(Span span, ServerCall<ReqT, RespT> call, GrpcServerParser parser) {
            super(call);
            this.span = span;
            this.parser = parser;
        }

        public void request(int numMessages) {
            this.span.start();
            super.request(numMessages);
        }

        public void sendMessage(RespT message) {
            super.sendMessage(message);
            this.parser.onMessageSent(message, this.span.customizer());
        }

        public void close(Status status, Metadata trailers) {
            try {
                super.close(status, trailers);
                this.parser.onClose(status, trailers, this.span.customizer());
            }
            catch (Error | RuntimeException e) {
                this.span.error(e);
                throw e;
            }
            finally {
                this.span.finish();
            }
        }
    }
}

