/*
 * Decompiled with CFR 0.152.
 */
package brave.grpc;

import brave.Tracing;
import brave.grpc.GrpcPropagation;
import brave.grpc.TracingClientInterceptor;
import brave.grpc.TracingServerInterceptor;
import brave.propagation.Propagation;
import brave.rpc.RpcTracing;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.ServerInterceptor;
import java.util.Map;

public final class GrpcTracing {
    final RpcTracing rpcTracing;
    final Map<String, Metadata.Key<String>> nameToKey;

    public static GrpcTracing create(Tracing tracing) {
        return GrpcTracing.newBuilder(tracing).build();
    }

    public static GrpcTracing create(RpcTracing rpcTracing) {
        return GrpcTracing.newBuilder(rpcTracing).build();
    }

    public static Builder newBuilder(Tracing tracing) {
        return GrpcTracing.newBuilder(RpcTracing.create((Tracing)tracing));
    }

    public static Builder newBuilder(RpcTracing rpcTracing) {
        return new Builder(rpcTracing);
    }

    GrpcTracing(Builder builder) {
        this.rpcTracing = builder.rpcTracing;
        this.nameToKey = GrpcPropagation.nameToKey((Propagation<String>)this.rpcTracing.propagation());
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public ClientInterceptor newClientInterceptor() {
        return new TracingClientInterceptor(this);
    }

    public ServerInterceptor newServerInterceptor() {
        return new TracingServerInterceptor(this);
    }

    public static final class Builder {
        RpcTracing rpcTracing;

        Builder(RpcTracing rpcTracing) {
            if (rpcTracing == null) {
                throw new NullPointerException("rpcTracing == null");
            }
            this.rpcTracing = rpcTracing;
        }

        Builder(GrpcTracing grpcTracing) {
            this.rpcTracing = grpcTracing.rpcTracing;
        }

        public GrpcTracing build() {
            return new GrpcTracing(this);
        }
    }
}

