/*
 * Decompiled with CFR 0.152.
 */
package brave.test.http;

import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import brave.test.ITRemote;
import brave.test.http.ITHttpServer;
import brave.test.http.ITServletContainer;
import brave.test.http.ServletContainer;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.Test;

public abstract class ITServlet25Container
extends ITServletContainer {
    public static final UnavailableException NOT_READY_UE = new UnavailableException(NOT_READY_ISE.getMessage(), 1){

        public Throwable fillInStackTrace() {
            return this;
        }
    };
    Filter delegate;
    Filter userFilter = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((HttpServletResponse)response).setHeader("user_id", ITRemote.BAGGAGE_FIELD.getValue());
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter traceContextFilter = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            TraceContext context = (TraceContext)request.getAttribute("brave.propagation.TraceContext");
            String value = ITRemote.BAGGAGE_FIELD.getValue(context);
            ((HttpServletResponse)response).setHeader("user_id", value);
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter customHttpRoute = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            request.setAttribute("http.route", (Object)((HttpServletRequest)request).getRequestURI());
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };
    Filter customHook = new Filter(){

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((SpanCustomizer)request.getAttribute("brave.SpanCustomizer")).tag("foo", "bar");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    };

    protected ITServlet25Container(ServletContainer.ServerController serverController) {
        super(serverController);
    }

    @Test
    protected void currentSpanVisibleToOtherFilters() throws Exception {
        this.delegate = this.userFilter;
        String path = "/foo";
        Request request = new Request.Builder().url(this.url(path)).header("user_id", "abcdefg").build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            Assertions.assertThat((String)response.header("user_id")).isEqualTo("abcdefg");
        }
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void traceContextVisibleToOtherFilters() throws Exception {
        this.delegate = this.traceContextFilter;
        String path = "/foo";
        Request request = new Request.Builder().url(this.url(path)).header("user_id", "abcdefg").build();
        try (Response response = this.client.newCall(request).execute();){
            Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
            Assertions.assertThat((String)response.header("user_id")).isEqualTo("abcdefg");
        }
        this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER);
    }

    @Test
    protected void canSetCustomRoute() throws Exception {
        this.delegate = this.customHttpRoute;
        this.get("/foo");
        Assertions.assertThat((String)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).name()).isEqualTo("GET /foo");
    }

    @Test
    protected void canUseSpanAttribute() throws Exception {
        this.delegate = this.customHook;
        this.get("/foo");
        Assertions.assertThat((Map)this.testSpanHandler.takeRemoteSpan(Span.Kind.SERVER).tags()).containsEntry((Object)"foo", (Object)"bar");
    }

    @Override
    public void init(ServletContextHandler handler) {
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(404)), "/*");
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(200)), "/foo");
        handler.addServlet(new ServletHolder((Servlet)new BaggageServlet()), "/baggage");
        handler.addServlet(new ServletHolder((Servlet)new StatusServlet(400)), "/badrequest");
        handler.addServlet(new ServletHolder((Servlet)new ChildServlet(this.httpTracing)), "/child");
        handler.addServlet(new ServletHolder((Servlet)new ExceptionServlet()), "/exception");
        this.addFilter(handler, this.newTracingFilter());
        this.addFilter(handler, new DelegatingFilter());
    }

    protected abstract Filter newTracingFilter();

    protected abstract void addFilter(ServletContextHandler var1, Filter var2);

    class DelegatingFilter
    implements Filter {
        DelegatingFilter() {
        }

        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (ITServlet25Container.this.delegate == null) {
                chain.doFilter(request, response);
            } else {
                ITServlet25Container.this.delegate.doFilter(request, response, chain);
            }
        }

        public void destroy() {
        }
    }

    static class ExceptionServlet
    extends HttpServlet {
        ExceptionServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            req.setAttribute("javax.servlet.error.status_code", (Object)503);
            throw ITHttpServer.NOT_READY_ISE;
        }
    }

    static class ChildServlet
    extends HttpServlet {
        final Tracer tracer;

        ChildServlet(HttpTracing httpTracing) {
            this.tracer = httpTracing.tracing().tracer();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            this.tracer.nextSpan().name("child").start().finish();
            resp.setStatus(200);
        }
    }

    static class BaggageServlet
    extends HttpServlet {
        BaggageServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().print(ITRemote.BAGGAGE_FIELD.getValue());
        }
    }

    static class StatusServlet
    extends HttpServlet {
        final int status;

        StatusServlet(int status) {
            this.status = status;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
            resp.setStatus(this.status);
        }
    }
}

