/*
 * Decompiled with CFR 0.152.
 */
package brave.jersey.server;

import brave.SpanCustomizer;
import brave.internal.Nullable;
import brave.jersey.server.EventParser;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.glassfish.jersey.uri.UriTemplate;

@Provider
public class SpanCustomizingApplicationEventListener
implements ApplicationEventListener,
RequestEventListener {
    final EventParser parser;

    public static SpanCustomizingApplicationEventListener create() {
        return new SpanCustomizingApplicationEventListener(new EventParser());
    }

    public static SpanCustomizingApplicationEventListener create(EventParser parser) {
        return new SpanCustomizingApplicationEventListener(parser);
    }

    @Inject
    SpanCustomizingApplicationEventListener(EventParser parser) {
        if (parser == null) {
            throw new NullPointerException("parser == null");
        }
        this.parser = parser;
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        if (requestEvent.getType() == RequestEvent.Type.START) {
            return this;
        }
        return null;
    }

    public void onEvent(RequestEvent event) {
        if (event.getType() != RequestEvent.Type.FINISHED) {
            return;
        }
        ContainerRequest request = event.getContainerRequest();
        Object maybeSpan = request.getProperty(SpanCustomizer.class.getName());
        if (!(maybeSpan instanceof SpanCustomizer)) {
            return;
        }
        request.setProperty("http.route", (Object)SpanCustomizingApplicationEventListener.route(request));
        Throwable error = SpanCustomizingApplicationEventListener.unwrapError(event);
        if (error != null && request.getProperty("error") == null) {
            request.setProperty("error", (Object)error);
        }
        this.parser.requestMatched(event, (SpanCustomizer)maybeSpan);
    }

    @Nullable
    static Throwable unwrapError(RequestEvent event) {
        Throwable error = event.getException();
        if (error instanceof MappableException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof WebApplicationException) {
            return error.getCause();
        }
        return error;
    }

    @Nullable
    static String route(ContainerRequest request) {
        ExtendedUriInfo uriInfo = request.getUriInfo();
        List templates = uriInfo.getMatchedTemplates();
        int templateCount = templates.size();
        if (templateCount == 0) {
            return "";
        }
        StringBuilder builder = null;
        String basePath = uriInfo.getBaseUri().getPath();
        String result = null;
        if (!"/".equals(basePath)) {
            result = basePath;
        }
        for (int i = templateCount - 1; i >= 0; --i) {
            String template = ((UriTemplate)templates.get(i)).getTemplate();
            if ("/".equals(template)) continue;
            if (builder != null) {
                builder.append(template);
                continue;
            }
            if (result != null) {
                builder = new StringBuilder(result).append(template);
                result = null;
                continue;
            }
            result = template;
        }
        return result != null ? result : (builder != null ? builder.toString() : "");
    }
}

