/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.clients;

import brave.Span;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;

final class TracingCallback {
    TracingCallback() {
    }

    static Callback create(@Nullable Callback delegate, Span span, CurrentTraceContext current) {
        if (delegate == null) {
            return new FinishSpan(span);
        }
        return new DelegateAndFinishSpan(delegate, span, current);
    }

    static class FinishSpan
    implements Callback {
        final Span span;

        FinishSpan(Span span) {
            this.span = span;
        }

        public void onCompletion(RecordMetadata metadata, @Nullable Exception exception) {
            if (exception != null) {
                this.span.error((Throwable)exception);
            }
            this.span.finish();
        }
    }

    static final class DelegateAndFinishSpan
    extends FinishSpan {
        final Callback delegate;
        final CurrentTraceContext current;

        DelegateAndFinishSpan(Callback delegate, Span span, CurrentTraceContext current) {
            super(span);
            this.delegate = delegate;
            this.current = current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(RecordMetadata metadata, @Nullable Exception exception) {
            try (CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());){
                this.delegate.onCompletion(metadata, exception);
            }
            finally {
                super.onCompletion(metadata, exception);
            }
        }
    }
}

