/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.internal.Throwables;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingProcessor<K, V>
implements Processor<K, V> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final Processor<K, V> delegateProcessor;
    ProcessorContext processorContext;

    TracingProcessor(KafkaStreamsTracing kafkaStreamsTracing, String spanName, Processor<K, V> delegateProcessor) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegateProcessor = delegateProcessor;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateProcessor.init(processorContext);
    }

    public void process(K k, V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
        Throwable error = null;
        try {
            this.delegateProcessor.process(k, v);
        }
        catch (Throwable e) {
            error = e;
            Throwables.propagateIfFatal((Throwable)e);
            throw e;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
            if (error != null) {
                span.error(error);
            }
            span.finish();
            ws.close();
        }
    }

    public void close() {
        this.delegateProcessor.close();
    }
}

