/*
 * Decompiled with CFR 0.152.
 */
package brave.mysql8;

import brave.Span;
import brave.mysql8.TracingQueryInterceptor;
import brave.propagation.ThreadLocalSpan;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.log.Log;
import java.sql.SQLException;
import java.util.Properties;

public class TracingExceptionInterceptor
implements ExceptionInterceptor {
    public ExceptionInterceptor init(Properties properties, Log log) {
        String queryInterceptors = properties.getProperty("queryInterceptors");
        if (queryInterceptors == null || !queryInterceptors.contains(TracingQueryInterceptor.class.getName())) {
            throw new IllegalStateException("TracingQueryInterceptor must be enabled to use TracingExceptionInterceptor.");
        }
        return new TracingExceptionInterceptor();
    }

    public void destroy() {
    }

    public Exception interceptException(Exception e) {
        Span span = ThreadLocalSpan.CURRENT_TRACER.remove();
        if (span == null || span.isNoop()) {
            return null;
        }
        span.error((Throwable)e);
        if (e instanceof SQLException) {
            span.tag("error", Integer.toString(((SQLException)e).getErrorCode()));
        }
        span.finish();
        return null;
    }
}

