/*
 * Decompiled with CFR 0.152.
 */
package brave.test.util;

import brave.test.util.GarbageCollectors;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.LogManager;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;

public final class ClassLoaders {
    public static <T> void assertRunIsUnloadableWithSupplier(Class<? extends ConsumerRunnable<T>> assertion, Class<? extends Supplier<? extends T>> supplier) {
        String property = assertion.getName() + ".supplier";
        System.setProperty(property, supplier.getName());
        try {
            ClassLoaders.assertRunIsUnloadable(assertion, assertion.getClassLoader());
        }
        finally {
            System.getProperties().remove(property);
        }
    }

    public static <T> T newInstance(Class<T> type, ClassLoader loader) {
        ((ClassAssert)Assertions.assertThat(type).withFailMessage(type + " should be a static member class", new Object[0])).satisfies(new ThrowingConsumer[]{c -> {
            Assertions.assertThat((boolean)c.isLocalClass()).isFalse();
            Assertions.assertThat((boolean)Modifier.isPublic(c.getModifiers())).isFalse();
        }});
        try {
            Class<?> classToInstantiate = loader.loadClass(type.getName());
            Constructor<?> ctor = classToInstantiate.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return (T)ctor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void assertRunIsUnloadable(Class<? extends Runnable> runnable, ClassLoader parent) {
        WeakReference<ClassLoader> loader;
        System.setProperty("java.util.logging.manager", LogManager.class.getName());
        Assertions.assertThat(LogManager.getLogManager().getClass()).isSameAs(LogManager.class);
        try {
            loader = ClassLoaders.invokeRunFromNewClassLoader(runnable, parent);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        GarbageCollectors.blockOnGC();
        ((ObjectAssert)Assertions.assertThat((Object)((ClassLoader)loader.get())).withFailMessage(runnable + " includes state that couldn't be garbage collected", new Object[0])).isNull();
    }

    static WeakReference<ClassLoader> invokeRunFromNewClassLoader(Class<? extends Runnable> runnable, ClassLoader parent) throws Exception {
        ClassLoader loader = ClassLoaders.reloadClassNamePrefix(parent, "brave");
        Runnable instance = ClassLoaders.newInstance(runnable, loader);
        Assertions.assertThat(instance.getClass()).isNotSameAs(runnable);
        Method run = instance.getClass().getMethod("run", new Class[0]);
        run.setAccessible(true);
        run.invoke((Object)instance, new Object[0]);
        return new WeakReference<ClassLoader>(loader);
    }

    static ClassLoader reloadClassNamePrefix(ClassLoader parent, final String prefix) {
        ClassLoader bridge = new ClassLoader(parent){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith(prefix)) {
                    throw new ClassNotFoundException("reloading type: " + name);
                }
                return super.loadClass(name, resolve);
            }
        };
        try {
            return new URLClassLoader(ClassLoaders.classpathToUrls(), bridge);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Couldn't read the current system classpath", e);
        }
    }

    static URL[] classpathToUrls() throws MalformedURLException {
        String[] classpath = System.getProperty("java.class.path").split(File.pathSeparator, -1);
        URL[] result = new URL[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            result[i] = new File(classpath[i]).toURI().toURL();
        }
        return result;
    }

    public static abstract class ConsumerRunnable<T>
    implements Runnable,
    Consumer<T> {
        Class<? extends Supplier<T>> subjectSupplier;

        protected ConsumerRunnable() {
            try {
                this.subjectSupplier = Class.forName(System.getProperty(this.getClass().getName() + ".supplier"));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void run() {
            this.accept(ClassLoaders.newInstance(this.subjectSupplier, this.getClass().getClassLoader()).get());
        }
    }
}

