/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.translation.stackdriver;

import com.google.devtools.cloudtrace.v2.Span;
import com.google.protobuf.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Annotation;
import zipkin2.Span;
import zipkin2.translation.stackdriver.AttributesExtractor;
import zipkin2.translation.stackdriver.SpanUtil;

public final class SpanTranslator {
    private static final Logger LOG = Logger.getLogger(SpanTranslator.class.getName());
    static final AttributesExtractor ATTRIBUTES_EXTRACTOR;
    private static final Map<String, String> SPRING6_RENAMED_HTTP_LABELS;

    public static List<com.google.devtools.cloudtrace.v2.Span> translate(String projectId, List<Span> zipkinSpans) {
        ArrayList<com.google.devtools.cloudtrace.v2.Span> result = new ArrayList<com.google.devtools.cloudtrace.v2.Span>(zipkinSpans.size());
        int len = zipkinSpans.size();
        for (int i = 0; i < len; ++i) {
            Span zipkinSpan = zipkinSpans.get(i);
            Span.Builder spanBuilder = SpanTranslator.translate(com.google.devtools.cloudtrace.v2.Span.newBuilder(), zipkinSpan);
            spanBuilder.setName("projects/" + projectId + "/traces/" + SpanTranslator.paddedTraceId(zipkinSpan.traceId()) + "/spans/" + zipkinSpan.id());
            result.add(spanBuilder.build());
        }
        return result;
    }

    public static Span.Builder translate(Span.Builder spanBuilder, Span zipkinSpan) {
        boolean logTranslation = LOG.isLoggable(Level.FINE);
        if (logTranslation) {
            LOG.log(Level.FINE, ">> translating zipkin span: {0}", zipkinSpan);
        }
        spanBuilder.setSpanId(zipkinSpan.id());
        if (zipkinSpan.parentId() != null) {
            spanBuilder.setParentSpanId(zipkinSpan.parentId());
        }
        spanBuilder.setDisplayName(SpanUtil.toTruncatableString(zipkinSpan.name() != null && !zipkinSpan.name().isEmpty() ? zipkinSpan.name() : "unknown"));
        if (zipkinSpan.timestampAsLong() != 0L) {
            spanBuilder.setStartTime(SpanTranslator.createTimestamp(zipkinSpan.timestampAsLong()));
            if (zipkinSpan.durationAsLong() != 0L) {
                Timestamp endTime = SpanTranslator.createTimestamp(zipkinSpan.timestampAsLong() + zipkinSpan.durationAsLong());
                spanBuilder.setEndTime(endTime);
            }
        }
        spanBuilder.setAttributes(ATTRIBUTES_EXTRACTOR.extract(zipkinSpan));
        if (zipkinSpan.name() != null && zipkinSpan.name().contains("http")) {
            zipkinSpan.tags().forEach((key, value) -> {
                if (SPRING6_RENAMED_HTTP_LABELS.containsKey(key)) {
                    spanBuilder.getAttributesBuilder().putAttributeMap(SPRING6_RENAMED_HTTP_LABELS.get(key), AttributesExtractor.toAttributeValue(value));
                }
            });
        }
        if (!zipkinSpan.annotations().isEmpty()) {
            Span.TimeEvents.Builder events = Span.TimeEvents.newBuilder();
            for (Annotation annotation : zipkinSpan.annotations()) {
                events.addTimeEvent(Span.TimeEvent.newBuilder().setTime(SpanTranslator.createTimestamp(annotation.timestamp())).setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(SpanUtil.toTruncatableString(annotation.value()))));
            }
            spanBuilder.setTimeEvents(events);
        }
        if (logTranslation) {
            LOG.log(Level.FINE, "<< translated to stackdriver span: {0}", spanBuilder);
        }
        return spanBuilder;
    }

    static Timestamp createTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        int remainderMicros = (int)(microseconds % 1000000L);
        int remainderNanos = remainderMicros * 1000;
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(remainderNanos).build();
    }

    static String paddedTraceId(String traceId) {
        if (traceId.length() == 32) {
            return traceId;
        }
        return "0000000000000000" + traceId;
    }

    static {
        LinkedHashMap<String, String> renamedLabels = new LinkedHashMap<String, String>();
        renamedLabels.put("http.host", "/http/host");
        renamedLabels.put("http.method", "/http/method");
        renamedLabels.put("http.status_code", "/http/status_code");
        renamedLabels.put("http.request.size", "/request/size");
        renamedLabels.put("http.response.size", "/response/size");
        renamedLabels.put("http.url", "/http/url");
        ATTRIBUTES_EXTRACTOR = new AttributesExtractor(renamedLabels);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("status", "/http/status_code");
        map.put("method", "/http/method");
        SPRING6_RENAMED_HTTP_LABELS = Collections.unmodifiableMap(map);
    }
}

