/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.urlconnection;

import java.net.URL;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.HttpEndpointSupplier;
import zipkin2.reporter.HttpEndpointSuppliers;
import zipkin2.reporter.internal.SenderAdapter;
import zipkin2.reporter.urlconnection.InternalURLConnectionSender;

public final class URLConnectionSender
extends SenderAdapter {
    final InternalURLConnectionSender delegate;
    final HttpEndpointSupplier.Factory endpointSupplierFactory;
    final String endpoint;

    public static URLConnectionSender create(String endpoint) {
        return URLConnectionSender.newBuilder().endpoint(endpoint).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    URLConnectionSender(Builder builder) {
        this.delegate = new InternalURLConnectionSender(builder);
        this.endpointSupplierFactory = builder.endpointSupplierFactory;
        this.endpoint = builder.endpoint;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BytesMessageSender delegate() {
        return this.delegate;
    }

    public static final class Builder {
        HttpEndpointSupplier.Factory endpointSupplierFactory = HttpEndpointSuppliers.constantFactory();
        String endpoint;
        Encoding encoding = Encoding.JSON;
        int messageMaxBytes = 500000;
        int connectTimeout = 10000;
        int readTimeout = 60000;
        boolean compressionEnabled = true;

        Builder(URLConnectionSender sender) {
            this.endpointSupplierFactory = sender.endpointSupplierFactory;
            this.endpoint = sender.endpoint;
            this.encoding = sender.delegate.encoding();
            this.messageMaxBytes = sender.delegate.messageMaxBytes;
            this.connectTimeout = sender.delegate.connectTimeout;
            this.readTimeout = sender.delegate.readTimeout;
            this.compressionEnabled = sender.delegate.compressionEnabled;
        }

        public Builder endpointSupplierFactory(HttpEndpointSupplier.Factory endpointSupplierFactory) {
            if (endpointSupplierFactory == null) {
                throw new NullPointerException("endpointSupplierFactory == null");
            }
            this.endpointSupplierFactory = endpointSupplierFactory;
            return this;
        }

        public Builder endpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(URL endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            this.endpoint = endpoint.toString();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder messageMaxBytes(int messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public Builder encoding(Encoding encoding) {
            if (encoding == null) {
                throw new NullPointerException("encoding == null");
            }
            this.encoding = encoding;
            return this;
        }

        public URLConnectionSender build() {
            if (this.endpoint == null) {
                throw new NullPointerException("endpoint == null");
            }
            return new URLConnectionSender(this);
        }

        Builder() {
        }
    }
}

