/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.provider.mysql;

import com.cedarsoftware.util.DeepEquals;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.mysql.cj.jdbc.MysqlDataSource;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.provider.DatabaseProvider;
import io.zonky.test.db.provider.EmbeddedDatabase;
import io.zonky.test.db.provider.ProviderException;
import io.zonky.test.db.provider.mysql.MySQLContainerCustomizer;
import io.zonky.test.db.provider.mysql.MySQLEmbeddedDatabase;
import io.zonky.test.db.provider.support.BlockingDatabaseWrapper;
import io.zonky.test.db.shaded.com.google.common.base.Throwables;
import io.zonky.test.db.shaded.com.google.common.cache.CacheBuilder;
import io.zonky.test.db.shaded.com.google.common.cache.CacheLoader;
import io.zonky.test.db.shaded.com.google.common.cache.LoadingCache;
import io.zonky.test.db.shaded.com.google.common.collect.ImmutableMap;
import io.zonky.test.db.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import io.zonky.test.db.util.PropertyUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

public class DockerMySQLDatabaseProvider
implements DatabaseProvider {
    private static final String DEFAULT_MYSQL_USERNAME = "test";
    private static final String DEFAULT_MYSQL_PASSWORD = "docker";
    private static final LoadingCache<DatabaseConfig, DatabasePool> databasesPools = CacheBuilder.newBuilder().build(new CacheLoader<DatabaseConfig, DatabasePool>(){

        @Override
        public DatabasePool load(DatabaseConfig config) {
            return new DatabasePool(config);
        }
    });
    private final DatabaseConfig databaseConfig;
    private final ClientConfig clientConfig;

    public DockerMySQLDatabaseProvider(Environment environment, ObjectProvider<List<MySQLContainerCustomizer>> containerCustomizers) {
        String dockerImage = environment.getProperty("zonky.test.database.mysql.docker.image", "mysql:5.7");
        String tmpfsOptions = environment.getProperty("zonky.test.database.mysql.docker.tmpfs.options", "rw,noexec,nosuid");
        boolean tmpfsEnabled = (Boolean)environment.getProperty("zonky.test.database.mysql.docker.tmpfs.enabled", Boolean.TYPE, (Object)false);
        Map<String, String> connectProperties = PropertyUtils.extractAll(environment, "zonky.test.database.mysql.client.properties");
        List customizers = Optional.ofNullable(containerCustomizers.getIfAvailable()).orElse(Collections.emptyList());
        this.databaseConfig = new DatabaseConfig(dockerImage, tmpfsOptions, tmpfsEnabled, customizers);
        this.clientConfig = new ClientConfig(connectProperties);
    }

    @Override
    public EmbeddedDatabase createDatabase(DatabasePreparer preparer) throws ProviderException {
        try {
            DatabasePool pool = databasesPools.get(this.databaseConfig);
            return pool.createDatabase(this.clientConfig, preparer);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
            throw new ProviderException("Unexpected error when preparing a database cluster", e.getCause());
        }
        catch (SQLException e) {
            throw new ProviderException("Unexpected error when creating a database", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerMySQLDatabaseProvider that = (DockerMySQLDatabaseProvider)o;
        return Objects.equals(this.databaseConfig, that.databaseConfig) && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        return Objects.hash(this.databaseConfig, this.clientConfig);
    }

    private static class ClientConfig {
        private final Map<String, String> connectProperties;

        private ClientConfig(Map<String, String> connectProperties) {
            this.connectProperties = ImmutableMap.copyOf(connectProperties);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfig that = (ClientConfig)o;
            return Objects.equals(this.connectProperties, that.connectProperties);
        }

        public int hashCode() {
            return Objects.hash(this.connectProperties);
        }
    }

    private static class DatabaseConfig {
        private final String dockerImage;
        private final String tmpfsOptions;
        private final boolean tmpfsEnabled;
        private final List<MySQLContainerCustomizer> customizers;

        private DatabaseConfig(String dockerImage, String tmpfsOptions, boolean tmpfsEnabled, List<MySQLContainerCustomizer> customizers) {
            this.dockerImage = dockerImage;
            this.tmpfsOptions = tmpfsOptions;
            this.tmpfsEnabled = tmpfsEnabled;
            this.customizers = customizers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfig that = (DatabaseConfig)o;
            return this.tmpfsEnabled == that.tmpfsEnabled && Objects.equals(this.dockerImage, that.dockerImage) && Objects.equals(this.tmpfsOptions, that.tmpfsOptions) && DeepEquals.deepEquals(this.customizers, that.customizers);
        }

        public int hashCode() {
            int result = Objects.hash(this.dockerImage, this.tmpfsOptions, this.tmpfsEnabled);
            result = 31 * result + DeepEquals.deepHashCode(this.customizers);
            return result;
        }
    }

    protected static class DatabaseInstance {
        private final DatabasePool databasePool;
        private final MySQLContainer container;
        private final Semaphore semaphore;

        private DatabaseInstance(DatabaseConfig config, DatabasePool pool) {
            this.databasePool = pool;
            this.container = this.createContainer(config.dockerImage);
            if (config.tmpfsEnabled) {
                Consumer<CreateContainerCmd> consumer = cmd -> cmd.getHostConfig().withTmpFs(ImmutableMap.of("/var/lib/mysql", config.tmpfsOptions));
                this.container.withCreateContainerCmdModifier(consumer);
            }
            this.container.withUsername(DockerMySQLDatabaseProvider.DEFAULT_MYSQL_USERNAME);
            this.container.withPassword(DockerMySQLDatabaseProvider.DEFAULT_MYSQL_PASSWORD);
            config.customizers.forEach(c -> c.customize(this.container));
            this.container.start();
            this.container.followOutput((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(DockerMySQLDatabaseProvider.class)));
            this.semaphore = new Semaphore(150);
        }

        private MySQLContainer createContainer(String dockerImage) {
            if (ClassUtils.hasMethod(DockerImageName.class, (String)"asCompatibleSubstituteFor", (Class[])new Class[]{String.class})) {
                return new MySQLContainer(DockerImageName.parse((String)dockerImage).asCompatibleSubstituteFor("mysql"));
            }
            return new MySQLContainer(dockerImage);
        }

        public EmbeddedDatabase createDatabase(ClientConfig config, DatabasePreparer preparer) throws SQLException {
            String databaseName = this.container.getDatabaseName();
            this.executeStatement(config, String.format("CREATE DATABASE IF NOT EXISTS %s", databaseName));
            try {
                EmbeddedDatabase database = this.getDatabase(config, databaseName);
                if (preparer != null) {
                    preparer.prepare(database);
                }
                return database;
            }
            catch (Exception e) {
                try {
                    this.cleanDatabase(config, databaseName);
                }
                catch (Exception ce) {
                    e.addSuppressed(ce);
                }
                throw e;
            }
        }

        protected void cleanDatabase(ClientConfig config, String dbName) {
            try {
                String dropCommand = "mysql -uroot -pdocker -N -e \"show databases\" | grep -v -E \"^(information_schema|performance_schema|mysql|sys)$\" | awk '{print \"drop database \" $1 \"\"}' | mysql -uroot -pdocker";
                Container.ExecResult dropResult = this.container.execInContainer(new String[]{"sh", "-c", dropCommand});
                if (dropResult.getExitCode() != 0) {
                    throw new ProviderException("Unexpected error when cleaning up the database");
                }
                this.databasePool.recycle(this);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf(e.getCause(), ProviderException.class);
                throw new ProviderException("Unexpected error when cleaning up the database", e.getCause());
            }
        }

        private void executeStatement(ClientConfig config, String ddlStatement) throws SQLException {
            EmbeddedDatabase dataSource = this.getDatabase(config, "mysql");
            try (Connection connection = dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(ddlStatement);){
                stmt.execute();
            }
        }

        private EmbeddedDatabase getDatabase(ClientConfig config, String dbName) {
            MysqlDataSource dataSource = new MysqlDataSource();
            dataSource.setServerName(this.container.getContainerIpAddress());
            dataSource.setPortNumber(this.container.getMappedPort(MySQLContainer.MYSQL_PORT.intValue()).intValue());
            dataSource.setDatabaseName(dbName);
            if ("mysql".equals(dbName)) {
                dataSource.setUser("root");
            } else {
                dataSource.setUser(this.container.getUsername());
            }
            dataSource.setPassword(this.container.getPassword());
            BeanWrapperImpl dataSourceWrapper = new BeanWrapperImpl((Object)dataSource);
            for (Map.Entry entry : config.connectProperties.entrySet()) {
                dataSourceWrapper.setPropertyValue((String)entry.getKey(), entry.getValue());
            }
            return new BlockingDatabaseWrapper(new MySQLEmbeddedDatabase(dataSource, () -> this.cleanDatabase(config, dbName)), this.semaphore);
        }
    }

    protected static class DatabasePool {
        private final BlockingQueue<DatabaseInstance> databaseInstances = new LinkedBlockingQueue<DatabaseInstance>();
        private final DatabaseConfig databaseConfig;

        private DatabasePool(DatabaseConfig config) {
            this.databaseConfig = config;
        }

        public EmbeddedDatabase createDatabase(ClientConfig config, DatabasePreparer preparer) throws SQLException {
            DatabaseInstance instance = (DatabaseInstance)this.databaseInstances.poll();
            if (instance == null) {
                instance = new DatabaseInstance(this.databaseConfig, this);
            }
            return instance.createDatabase(config, preparer);
        }

        private void recycle(DatabaseInstance instance) {
            this.databaseInstances.offer(instance);
        }
    }
}

