/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.flyway.preparer;

import io.zonky.test.db.flyway.FlywayDescriptor;
import io.zonky.test.db.flyway.FlywayWrapper;
import io.zonky.test.db.preparer.DatabasePreparer;
import io.zonky.test.db.shaded.com.google.common.base.MoreObjects;
import io.zonky.test.db.shaded.com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlywayDatabasePreparer
implements DatabasePreparer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final CompletableFuture<Object> result = new CompletableFuture();
    protected final FlywayDescriptor descriptor;

    public FlywayDatabasePreparer(FlywayDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public FlywayDescriptor getDescriptor() {
        return this.descriptor;
    }

    public CompletableFuture<Object> getResult() {
        return this.result;
    }

    protected abstract Object doOperation(FlywayWrapper var1);

    @Override
    public void prepare(DataSource dataSource) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        FlywayWrapper wrapper = FlywayWrapper.newInstance();
        this.descriptor.applyTo(wrapper);
        wrapper.setDataSource(dataSource);
        try {
            this.result.complete(this.doOperation(wrapper));
            this.logger.trace("Database has been successfully prepared in {}", (Object)stopwatch);
        }
        catch (RuntimeException e) {
            this.result.completeExceptionally(e);
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayDatabasePreparer that = (FlywayDatabasePreparer)o;
        return Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("schemas", this.descriptor.getSchemas()).add("estimatedDuration", this.estimatedDuration()).toString();
    }
}

