/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import io.zonky.test.db.postgres.embedded.DatabasePreparer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

public final class FlywayPreparer
implements DatabasePreparer {
    private final FluentConfiguration configuration;
    private final List<String> locations;

    public static FlywayPreparer forClasspathLocation(String ... locations) {
        FluentConfiguration config = Flyway.configure().locations(locations);
        return new FlywayPreparer(config, Arrays.asList(locations));
    }

    private FlywayPreparer(FluentConfiguration configuration, List<String> locations) {
        this.configuration = configuration;
        this.locations = locations;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        this.configuration.dataSource(ds);
        Flyway flyway = this.configuration.load();
        try {
            MethodUtils.invokeMethod((Object)flyway, (String)"migrate");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlywayPreparer)) {
            return false;
        }
        return Objects.equals(this.locations, ((FlywayPreparer)obj).locations);
    }

    public int hashCode() {
        return Objects.hashCode(this.locations);
    }
}

