/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.embedded;

import io.zonky.test.db.postgres.embedded.DatabasePreparer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

public final class FlywayPreparer
implements DatabasePreparer {
    private final FluentConfiguration configuration;
    private final List<String> locations;
    private final Map<String, String> properties;

    public static FlywayPreparer forClasspathLocation(String ... locations) {
        FluentConfiguration config = Flyway.configure().locations(locations);
        return new FlywayPreparer(config, Arrays.asList(locations), null);
    }

    public static FlywayPreparer fromConfiguration(Map<String, String> configuration) {
        FluentConfiguration config = Flyway.configure().configuration(configuration);
        return new FlywayPreparer(config, null, new HashMap<String, String>(configuration));
    }

    private FlywayPreparer(FluentConfiguration configuration, List<String> locations, Map<String, String> properties) {
        this.configuration = configuration;
        this.locations = locations;
        this.properties = properties;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        this.configuration.dataSource(ds);
        Flyway flyway = this.configuration.load();
        try {
            MethodUtils.invokeMethod((Object)flyway, (String)"migrate");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlywayPreparer that = (FlywayPreparer)o;
        return Objects.equals(this.locations, that.locations) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.properties);
    }
}

