/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.UnicodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class YamlToPropertiesConverter {
    YamlToPropertiesConverter() {
    }

    static Properties convertToProperties(InputStream inputStream) throws MojoExecutionException {
        Properties properties = new Properties();
        Yaml yaml = new Yaml();
        Object object = yaml.load((Reader)new UnicodeReader(inputStream));
        if (object != null && object instanceof Map) {
            try {
                Map map = (Map)object;
                Map<String, String> flatMap = YamlToPropertiesConverter.flattenMap(map);
                properties.putAll(flatMap);
            }
            catch (StackOverflowError e) {
                throw new MojoExecutionException("The Yaml file has too many hierarchies", (Throwable)e);
            }
        }
        return properties;
    }

    private static Map<String, String> flattenMap(Map mapOfObjects) {
        Map<String, Object> mapOfMaps = YamlToPropertiesConverter.toHierarchicalMap(mapOfObjects);
        Map<String, Object> flattenedMap = YamlToPropertiesConverter.toFlatMap(mapOfMaps);
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : flattenedMap.entrySet()) {
            propertiesMap.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return propertiesMap;
    }

    private static Map<String, Object> toHierarchicalMap(Object content) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : ((Map)content).entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            YamlToPropertiesConverter.toHierarchicalValue(dataMap, key, value);
        }
        return dataMap;
    }

    private static void toHierarchicalValue(Map<String, Object> dataMap, String key, Object value) {
        if (value instanceof Map) {
            dataMap.put(key, YamlToPropertiesConverter.toHierarchicalMap(value));
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                YamlToPropertiesConverter.toHierarchicalValue(dataMap, key, element);
            }
        } else {
            dataMap.put(key, value == null ? "" : value);
        }
    }

    private static Map<String, Object> toFlatMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> flattenedMap = new LinkedHashMap<String, Object>();
        for (String key : source.keySet()) {
            Object value = source.get(key);
            if (value instanceof Map) {
                Map<String, Object> nestedMap = YamlToPropertiesConverter.toFlatMap((Map)value);
                for (String nestedKey : nestedMap.keySet()) {
                    flattenedMap.put(String.format("%s.%s", key, nestedKey), nestedMap.get(nestedKey));
                }
                continue;
            }
            if (value instanceof Collection) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean firstElement = true;
                for (Object element : (Collection)value) {
                    Map<String, Object> subMap = YamlToPropertiesConverter.toFlatMap(Collections.singletonMap(key, element));
                    if (firstElement) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(subMap.entrySet().iterator().next().getValue().toString());
                    firstElement = false;
                }
                flattenedMap.put(key, stringBuilder.toString());
                continue;
            }
            flattenedMap.put(key, value == null ? "" : value);
        }
        return flattenedMap;
    }
}

