/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.UnspecifiedParameterException;
import java.awt.Color;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSAPResult
implements ExceptionMap {
    private Map allResults = new HashMap();
    private Map qualifiedSwitches = null;
    private Map allExceptions = new HashMap();
    private List chronologicalErrorMessages = new LinkedList();
    private Set userSpecifiedIDs = null;
    private boolean valuesFromUser = false;

    protected JSAPResult() {
        this.qualifiedSwitches = new HashMap();
        this.userSpecifiedIDs = new HashSet();
    }

    void setValuesFromUser(boolean bl) {
        this.valuesFromUser = bl;
    }

    public boolean contains(String string) {
        return this.allResults.containsKey(string);
    }

    public boolean userSpecified(String string) {
        return this.userSpecifiedIDs.contains(string);
    }

    protected void add(String string, List list) {
        List list2 = null;
        if (this.allResults.containsKey(string)) {
            list2 = (List)this.allResults.get(string);
        } else {
            list2 = new ArrayList();
            this.allResults.put(string, list2);
        }
        list2.addAll(list);
        if (this.valuesFromUser) {
            this.userSpecifiedIDs.add(string);
        }
    }

    @Override
    public void addException(String string, Exception exception) {
        List<Exception> list = null;
        if (this.allExceptions.containsKey(string)) {
            list = (List)this.allExceptions.get(string);
        } else {
            list = new ArrayList();
            this.allExceptions.put(string, list);
        }
        list.add(exception);
        this.chronologicalErrorMessages.add(exception.getMessage());
    }

    public Object getObject(String string) {
        Object var2_2 = null;
        List list = (List)this.allResults.get(string);
        if (list != null && list.size() > 0) {
            var2_2 = list.get(0);
        }
        return var2_2;
    }

    public Object[] getObjectArray(String string) {
        ArrayList arrayList = (ArrayList)this.allResults.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList(0);
        }
        return arrayList.toArray();
    }

    public Object[] getObjectArray(String string, Object[] objectArray) {
        ArrayList arrayList = (ArrayList)this.allResults.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList.toArray(objectArray);
    }

    public boolean getBoolean(String string) {
        Boolean bl = (Boolean)this.qualifiedSwitches.get(string);
        if (bl == null) {
            if (!this.contains(string)) {
                throw new UnspecifiedParameterException(string);
            }
            bl = (Boolean)this.getObject(string);
        }
        return bl;
    }

    public boolean getBoolean(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.qualifiedSwitches.get(string);
        if (bl2 == null) {
            bl2 = (Boolean)this.getObject(string);
        }
        return bl2 == null ? bl : bl2;
    }

    public boolean[] getBooleanArray(String string) {
        Boolean[] booleanArray = (Boolean[])this.getObjectArray(string, new Boolean[0]);
        int n = booleanArray.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = booleanArray[i];
        }
        return blArray;
    }

    public int getInt(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return (Integer)this.getObject(string);
    }

    public int getInt(String string, int n) {
        Integer n2 = (Integer)this.getObject(string);
        return n2 == null ? n : n2;
    }

    public String getQualifiedSwitchValue(String string) {
        Object var2_2 = null;
        List list = (List)this.allResults.get(string);
        if (list != null && list.size() == 2) {
            var2_2 = list.get(1);
        }
        return var2_2;
    }

    public int[] getIntArray(String string) {
        Integer[] integerArray = (Integer[])this.getObjectArray(string, new Integer[0]);
        int n = integerArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public long getLong(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return (Long)this.getObject(string);
    }

    public long getLong(String string, long l) {
        Long l2 = (Long)this.getObject(string);
        return l2 == null ? l : l2;
    }

    public long[] getLongArray(String string) {
        Long[] longArray = (Long[])this.getObjectArray(string, new Long[0]);
        int n = longArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = longArray[i];
        }
        return lArray;
    }

    public byte getByte(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return (Byte)this.getObject(string);
    }

    public byte getByte(String string, byte by) {
        Byte by2 = (Byte)this.getObject(string);
        return by2 == null ? by : by2;
    }

    public byte[] getByteArray(String string) {
        Byte[] byteArray = (Byte[])this.getObjectArray(string, new Byte[0]);
        int n = byteArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = byteArray[i];
        }
        return byArray;
    }

    public char getChar(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return ((Character)this.getObject(string)).charValue();
    }

    public char getChar(String string, char c) {
        Character c2 = (Character)this.getObject(string);
        return c2 == null ? c : c2.charValue();
    }

    public char[] getCharArray(String string) {
        Character[] characterArray = (Character[])this.getObjectArray(string, new Character[0]);
        int n = characterArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = characterArray[i].charValue();
        }
        return cArray;
    }

    public short getShort(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return (Short)this.getObject(string);
    }

    public short getShort(String string, short s) {
        Short s2 = (Short)this.getObject(string);
        return s2 == null ? s : s2;
    }

    public short[] getShortArray(String string) {
        Short[] shortArray = (Short[])this.getObjectArray(string, new Short[0]);
        int n = shortArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = shortArray[i];
        }
        return sArray;
    }

    public double getDouble(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return (Double)this.getObject(string);
    }

    public double getDouble(String string, double d) {
        Double d2 = (Double)this.getObject(string);
        return d2 == null ? d : d2;
    }

    public double[] getDoubleArray(String string) {
        Double[] doubleArray = (Double[])this.getObjectArray(string, new Double[0]);
        int n = doubleArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = doubleArray[i];
        }
        return dArray;
    }

    public float getFloat(String string) {
        if (!this.contains(string)) {
            throw new UnspecifiedParameterException(string);
        }
        return ((Float)this.getObject(string)).floatValue();
    }

    public float getFloat(String string, float f) {
        Float f2 = (Float)this.getObject(string);
        return f2 == null ? f : f2.floatValue();
    }

    public float[] getFloatArray(String string) {
        Float[] floatArray = (Float[])this.getObjectArray(string, new Float[0]);
        int n = floatArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = floatArray[i].floatValue();
        }
        return fArray;
    }

    public String getString(String string) {
        return (String)this.getObject(string);
    }

    public String getString(String string, String string2) {
        String string3 = (String)this.getObject(string);
        return string3 == null ? string2 : string3;
    }

    public String[] getStringArray(String string) {
        return (String[])this.getObjectArray(string, new String[0]);
    }

    public BigDecimal getBigDecimal(String string) {
        return (BigDecimal)this.getObject(string);
    }

    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = (BigDecimal)this.getObject(string);
        return bigDecimal2 == null ? bigDecimal : bigDecimal2;
    }

    public BigDecimal[] getBigDecimalArray(String string) {
        return (BigDecimal[])this.getObjectArray(string, new BigDecimal[0]);
    }

    public BigInteger getBigInteger(String string) {
        return (BigInteger)this.getObject(string);
    }

    public BigInteger getBigInteger(String string, BigInteger bigInteger) {
        BigInteger bigInteger2 = (BigInteger)this.getObject(string);
        return bigInteger2 == null ? bigInteger : bigInteger2;
    }

    public BigInteger[] getBigIntegerArray(String string) {
        return (BigInteger[])this.getObjectArray(string, new BigInteger[0]);
    }

    public Class getClass(String string) {
        return (Class)this.getObject(string);
    }

    public Class getClass(String string, Class clazz) {
        Class clazz2 = (Class)this.getObject(string);
        return clazz2 == null ? clazz : clazz2;
    }

    public Class[] getClassArray(String string) {
        return (Class[])this.getObjectArray(string, new Class[0]);
    }

    public InetAddress getInetAddress(String string) {
        return (InetAddress)this.getObject(string);
    }

    public InetAddress getInetAddress(String string, InetAddress inetAddress) {
        InetAddress inetAddress2 = (InetAddress)this.getObject(string);
        return inetAddress2 == null ? inetAddress : inetAddress2;
    }

    public InetAddress[] getInetAddressArray(String string) {
        return (InetAddress[])this.getObjectArray(string, new InetAddress[0]);
    }

    public Package getPackage(String string) {
        return (Package)this.getObject(string);
    }

    public Package getPackage(String string, Package package_) {
        Package package_2 = (Package)this.getObject(string);
        return package_2 == null ? package_ : package_2;
    }

    public Package[] getPackageArray(String string) {
        return (Package[])this.getObjectArray(string, new Package[0]);
    }

    public URL getURL(String string) {
        return (URL)this.getObject(string);
    }

    public URL getURL(String string, URL uRL) {
        URL uRL2 = (URL)this.getObject(string);
        return uRL2 == null ? uRL : uRL2;
    }

    public URL[] getURLArray(String string) {
        return (URL[])this.getObjectArray(string, new URL[0]);
    }

    public Color getColor(String string) {
        return (Color)this.getObject(string);
    }

    public File getFile(String string) {
        return (File)this.getObject(string);
    }

    public Color getColor(String string, Color color) {
        Color color2 = (Color)this.getObject(string);
        return color2 == null ? color : color2;
    }

    public File getFile(String string, File file) {
        File file2 = (File)this.getObject(string);
        return file2 == null ? file : file2;
    }

    public Color[] getColorArray(String string) {
        return (Color[])this.getObjectArray(string, new Color[0]);
    }

    public File[] getFileArray(String string) {
        return (File[])this.getObjectArray(string, new File[0]);
    }

    public Date getDate(String string) {
        return (Date)this.getObject(string);
    }

    public Date getDate(String string, Date date) {
        Date date2 = (Date)this.getObject(string);
        return date2 == null ? date : date2;
    }

    public Date[] getDateArray(String string) {
        return (Date[])this.getObjectArray(string, new Date[0]);
    }

    @Override
    public Exception getException(String string) {
        Exception exception = null;
        List list = (List)this.allExceptions.get(string);
        if (list != null && list.size() > 0) {
            exception = (Exception)list.get(0);
        }
        return exception;
    }

    @Override
    public Exception[] getExceptionArray(String string) {
        Exception[] exceptionArray = new Exception[]{};
        List list = (List)this.allExceptions.get(string);
        if (list != null) {
            exceptionArray = list.toArray(exceptionArray);
        }
        return exceptionArray;
    }

    public Iterator getExceptionIterator(String string) {
        ArrayList arrayList = (ArrayList)this.allExceptions.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList.iterator();
    }

    public Iterator getErrorMessageIterator() {
        return this.chronologicalErrorMessages.iterator();
    }

    public Iterator getBadParameterIDIterator() {
        return this.allExceptions.keySet().iterator();
    }

    public boolean success() {
        return this.allExceptions.size() == 0;
    }

    void registerQualifiedSwitch(String string, boolean bl) {
        this.qualifiedSwitches.put(string, new Boolean(bl));
    }
}

