/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHolder {
    private Project project;
    private String installText;

    static void parseCompileProperties(String value, Vector<String> fragments, Vector<String> propertyRefs) throws BuildException {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("@", prev)) >= 0) {
            if (pos > 0) {
                fragments.addElement(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.addElement("@");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '@') {
                    fragments.addElement("@");
                    prev = pos + 2;
                    continue;
                }
                fragments.addElement(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new BuildException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.addElement(null);
            propertyRefs.addElement(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.addElement(value.substring(prev));
        }
    }

    ConfigHolder(Project project) {
        this.project = project;
    }

    public void addText(String rawText) {
        Vector<String> fragments = new Vector<String>();
        Vector<String> propertyRefs = new Vector<String>();
        ConfigHolder.parseCompileProperties(rawText, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Enumeration<String> i = fragments.elements();
        Enumeration<String> j = propertyRefs.elements();
        while (i.hasMoreElements()) {
            String fragment = i.nextElement();
            if (fragment == null) {
                String propertyName = j.nextElement();
                String replacement = null;
                if (replacement == null) {
                    replacement = this.project.getProperty(propertyName);
                }
                if (replacement == null) {
                    this.project.log("Property @{" + propertyName + "} has not been set", 3);
                }
                fragment = replacement != null ? replacement.toString() : "@{" + propertyName + "}";
            }
            sb.append(fragment);
        }
        this.installText = sb.toString();
    }

    public String getText() {
        return this.installText;
    }
}

