/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import java.io.IOException;
import java.io.OutputStream;

public class ByteCountingOutputStream
extends OutputStream {
    private long count;
    private OutputStream os;

    public ByteCountingOutputStream(OutputStream os) {
        this.os = os;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.count += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.count += (long)b.length;
    }

    public void write(int b) throws IOException {
        this.os.write(b);
        this.count += 4L;
    }

    public void close() throws IOException {
        this.os.close();
    }

    public void flush() throws IOException {
        this.os.flush();
    }

    public long getByteCount() {
        return this.count;
    }
}

