/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.compiler.ByteCountingOutputStream;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerBase;
import com.izforge.izpack.compiler.PackagerHelper;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.JarOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packager
extends PackagerBase {
    private JarOutputStream primaryJarStream;

    public Packager() throws CompilerException {
        this("default");
    }

    public Packager(String compr_format) throws CompilerException {
        this(compr_format, -1);
    }

    public Packager(String compr_format, int compr_level) throws CompilerException {
        this.initPackCompressor(compr_format, compr_level);
    }

    @Override
    public void createInstaller(File primaryFile) throws Exception {
        String baseName = primaryFile.getName();
        if (baseName.endsWith(".jar")) {
            baseName = baseName.substring(0, baseName.length() - 4);
            this.baseFile = new File(primaryFile.getParentFile(), baseName);
        } else {
            this.baseFile = primaryFile;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        this.packJarsSeparate = this.info.getWebDirURL() != null;
        this.primaryJarStream = this.getJarOutputStream(this.baseFile.getName() + ".jar");
        this.sendStart();
        this.writeInstaller();
        this.primaryJarStream.closeAlways();
        this.sendStop();
    }

    @Override
    protected void writeSkeletonInstaller() throws IOException {
        this.sendMsg("Copying the skeleton installer", 3);
        InputStream is = Packager.class.getResourceAsStream("/lib/installer.jar");
        if (is == null) {
            File skeleton = new File(Compiler.IZPACK_HOME, "lib/installer.jar");
            is = new FileInputStream(skeleton);
        }
        ZipInputStream inJarStream = new ZipInputStream(is);
        this.copyZip(inJarStream, this.primaryJarStream);
    }

    @Override
    protected void writeInstallerObject(String entryName, Object object) throws IOException {
        this.primaryJarStream.putNextEntry(new ZipEntry(entryName));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeObject(object);
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    @Override
    protected void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer");
        for (String name : this.installerResourceURLMap.keySet()) {
            InputStream in = ((URL)this.installerResourceURLMap.get(name)).openStream();
            ZipEntry newEntry = new ZipEntry(name);
            long dateTime = FileUtil.getFileDateTime((URL)this.installerResourceURLMap.get(name));
            if (dateTime != -1L) {
                newEntry.setTime(dateTime);
            }
            this.primaryJarStream.putNextEntry(newEntry);
            PackagerHelper.copyStream(in, this.primaryJarStream);
            this.primaryJarStream.closeEntry();
            in.close();
        }
    }

    @Override
    protected void writeIncludedJars() throws IOException {
        this.sendMsg("Merging " + this.includedJarURLs.size() + " jars into installer");
        for (Object[] current : this.includedJarURLs) {
            InputStream is = ((URL)current[0]).openStream();
            ZipInputStream inJarStream = new ZipInputStream(is);
            this.copyZip(inJarStream, this.primaryJarStream, (List)current[1]);
        }
    }

    @Override
    protected void writePacks() throws Exception {
        int num = this.packsList.size();
        this.sendMsg("Writing " + num + " Pack" + (num > 1 ? "s" : "") + " into installer");
        HashMap<File, Object[]> storedFiles = new HashMap<File, Object[]>();
        int packNumber = 0;
        Iterator packIter = this.packsList.iterator();
        XMLElement root = new XMLElement("packs");
        while (packIter.hasNext()) {
            PackInfo packInfo = (PackInfo)packIter.next();
            Pack pack = packInfo.getPack();
            pack.nbytes = 0L;
            if (pack.id == null || pack.id.length() == 0) {
                pack.id = pack.name;
            }
            JarOutputStream packStream = this.primaryJarStream;
            if (this.packJarsSeparate) {
                String name = this.baseFile.getName() + ".pack-" + pack.id + ".jar";
                packStream = this.getJarOutputStream(name);
            }
            OutputStream comprStream = packStream;
            this.sendMsg("Writing Pack " + packNumber + ": " + pack.name, 3);
            ZipEntry entry = new ZipEntry("packs/pack-" + pack.id);
            if (!this.compressor.useStandardCompression()) {
                entry.setMethod(0);
                entry.setComment(this.compressor.getCompressionFormatSymbols()[0]);
                packStream.putNextEntry(entry);
                packStream.flush();
                comprStream = this.compressor.getOutputStream(packStream);
            } else {
                int level = this.compressor.getCompressionLevel();
                if (level >= 0 && level < 10) {
                    packStream.setLevel(level);
                }
                packStream.putNextEntry(entry);
                packStream.flush();
            }
            ByteCountingOutputStream dos = new ByteCountingOutputStream(comprStream);
            ObjectOutputStream objOut = new ObjectOutputStream(dos);
            objOut.writeInt(packInfo.getPackFiles().size());
            Iterator iter = packInfo.getPackFiles().iterator();
            while (iter.hasNext()) {
                boolean addFile = !pack.loose;
                PackFile pf = (PackFile)iter.next();
                File file = packInfo.getFile(pf);
                Object[] info = (Object[])storedFiles.get(file);
                if (info != null && !this.packJarsSeparate) {
                    pf.setPreviousPackFileRef((String)info[0], (Long)info[1]);
                    addFile = false;
                }
                objOut.writeObject(pf);
                objOut.flush();
                if (addFile && !pf.isDirectory()) {
                    long pos = dos.getByteCount();
                    FileInputStream inStream = new FileInputStream(file);
                    long bytesWritten = PackagerHelper.copyStream(inStream, objOut);
                    if (bytesWritten != pf.length()) {
                        throw new IOException("File size mismatch when reading " + file);
                    }
                    inStream.close();
                    storedFiles.put(file, new Object[]{pack.id, pos});
                }
                pack.nbytes += pf.length();
            }
            objOut.writeInt(packInfo.getParsables().size());
            iter = packInfo.getParsables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getExecutables().size());
            iter = packInfo.getExecutables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getUpdateChecks().size());
            iter = packInfo.getUpdateChecks().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.flush();
            if (!this.compressor.useStandardCompression()) {
                comprStream.close();
            }
            packStream.closeEntry();
            if (this.packJarsSeparate) {
                packStream.closeAlways();
            }
            XMLElement child = new XMLElement("pack");
            child.setAttribute("nbytes", Long.toString(pack.nbytes));
            child.setAttribute("name", pack.name);
            if (pack.id != null) {
                child.setAttribute("id", pack.id);
            }
            root.addChild(child);
            ++packNumber;
        }
        if (this.packJarsSeparate) {
            FileWriter writer = new FileWriter(this.baseFile.getParent() + File.separator + "packsinfo.xml");
            XMLWriter xmlwriter = new XMLWriter(writer);
            xmlwriter.write(root);
        }
        this.primaryJarStream.putNextEntry(new ZipEntry("packs.info"));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeInt(this.packsList.size());
        for (PackInfo pack : this.packsList) {
            out.writeObject(pack.getPack());
        }
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    private JarOutputStream getJarOutputStream(String name) throws IOException {
        File file = new File(this.baseFile.getParentFile(), name);
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        JarOutputStream jar = new JarOutputStream(file);
        jar.setLevel(9);
        jar.setPreventClose(true);
        return jar;
    }

    private void copyZip(ZipInputStream zin, ZipOutputStream out) throws IOException {
        this.copyZip(zin, out, null);
    }

    private void copyZip(ZipInputStream zin, ZipOutputStream out, List<String> files) throws IOException {
        java.util.zip.ZipEntry zentry;
        if (!this.alreadyWrittenFiles.containsKey(out)) {
            this.alreadyWrittenFiles.put(out, new HashSet());
        }
        HashSet currentSet = (HashSet)this.alreadyWrittenFiles.get(out);
        while ((zentry = zin.getNextEntry()) != null) {
            String currentName = zentry.getName();
            String testName = currentName.replace('/', '.');
            testName = testName.replace('\\', '.');
            if (files != null) {
                Iterator<String> i = files.iterator();
                boolean founded = false;
                while (i.hasNext()) {
                    String doInclude = i.next();
                    if (!testName.matches(doInclude)) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
            }
            if (currentSet.contains(currentName)) continue;
            try {
                ZipEntry newEntry = new ZipEntry(currentName);
                long fileTime = zentry.getTime();
                if (fileTime != -1L) {
                    newEntry.setTime(fileTime);
                }
                out.putNextEntry(newEntry);
                PackagerHelper.copyStream(zin, out);
                out.closeEntry();
                zin.closeEntry();
                currentSet.add(currentName);
            }
            catch (ZipException x) {}
        }
    }

    @Override
    public void addConfigurationInformation(XMLElement data) {
    }
}

