/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.advice;

import java.lang.reflect.Method;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistry;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ServiceAllowedMethodBeforeAdvice
implements MethodBeforeAdvice,
InitializingBean {
    private ServiceRegistry serviceRegistry;

    public final void before(Method method, Object[] args, Object target) throws UnauthorizedServiceException {
        Service service = (Service)args[1];
        RegisteredService authenticatedService = this.serviceRegistry.getService(WebUtils.stripJsessionFromUrl(service.getId()));
        if (authenticatedService == null) {
            throw new UnauthorizedServiceException("Service: [" + service.getId() + "] not found in registry.");
        }
        this.beforeInternal(method, args, target, authenticatedService);
    }

    protected void beforeInternal(Method method, Object[] args, Object target, RegisteredService service) {
    }

    public final ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public final void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.serviceRegistry, (String)"serviceRegistry is a required property.");
        this.afterPropertiesSetInternal();
    }

    public void afterPropertiesSetInternal() throws Exception {
    }
}

