/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.SimpleService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class ProxyController
extends AbstractController
implements InitializingBean {
    private static final String CONST_PROXY_FAILURE = "casProxyFailureView";
    private static final String CONST_PROXY_SUCCESS = "casProxySuccessView";
    private CentralAuthenticationService centralAuthenticationService;

    public ProxyController() {
        this.setCacheSeconds(0);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.centralAuthenticationService, (String)("centralAuthenticationService cannot be null on " + ((Object)((Object)this)).getClass().getName()));
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticket = request.getParameter("pgt");
        String targetService = request.getParameter("targetService");
        HashMap<String, String> model = new HashMap<String, String>();
        if (!StringUtils.hasText((String)ticket) || !StringUtils.hasText((String)targetService)) {
            model.put("code", "INVALID_REQUEST");
            model.put("description", this.getMessageSourceAccessor().getMessage("INVALID_REQUEST_PROXY", "INVALID_REQUEST_PROXY"));
            return new ModelAndView(CONST_PROXY_FAILURE, model);
        }
        try {
            SimpleService service = new SimpleService(WebUtils.stripJsessionFromUrl(targetService));
            return new ModelAndView(CONST_PROXY_SUCCESS, "ticket", (Object)this.centralAuthenticationService.grantServiceTicket(ticket, service));
        }
        catch (TicketException e) {
            model.put("code", e.getCode());
            model.put("description", this.getMessageSourceAccessor().getMessage(e.getCode(), new Object[]{ticket}, e.getCode()));
            return new ModelAndView(CONST_PROXY_FAILURE, model);
        }
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

