/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.attribute.ResponseAddress;
import de.javawi.jstun.attribute.SourceAddress;
import de.javawi.jstun.attribute.UnknownAttribute;
import de.javawi.jstun.attribute.UnknownMessageAttributeException;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class StunServer {
    private static Logger logger = Logger.getLogger("de.javawi.stun.test.StunServer");
    Vector<DatagramSocket> sockets = new Vector();
    Vector<Thread> threads;
    private boolean enabled = false;

    public StunServer(int primaryPort, InetAddress primary, int secondaryPort, InetAddress secondary) throws SocketException {
        this.sockets.add(new DatagramSocket(primaryPort, primary));
        this.sockets.add(new DatagramSocket(secondaryPort, primary));
        this.sockets.add(new DatagramSocket(primaryPort, secondary));
        this.sockets.add(new DatagramSocket(secondaryPort, secondary));
        this.threads = new Vector();
        for (DatagramSocket socket : this.sockets) {
            socket.setReceiveBufferSize(2000);
            StunServerReceiverThread ssrt = new StunServerReceiverThread(socket);
            this.threads.add(ssrt);
        }
    }

    public void start() throws SocketException {
        for (Thread ssrt : this.threads) {
            ssrt.start();
        }
        this.enabled = true;
    }

    public void stop() {
        this.enabled = false;
        for (DatagramSocket socket : this.sockets) {
            socket.close();
        }
        this.sockets.clear();
        this.threads.clear();
    }

    public static void main(String[] args) {
        try {
            FileHandler fh = new FileHandler("logging_server.txt");
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("de.javawi.stun").addHandler(fh);
            Logger.getLogger("de.javawi.stun").setLevel(Level.ALL);
            StunServer ss = new StunServer(Integer.parseInt(args[0]), InetAddress.getByName(args[1]), Integer.parseInt(args[2]), InetAddress.getByName(args[3]));
            ss.start();
            ss.stop();
            Object var2_5 = null;
        }
        catch (SocketException se) {
            se.printStackTrace();
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    class StunServerReceiverThread
    extends Thread {
        private DatagramSocket receiverSocket;
        private DatagramSocket changedPort;
        private DatagramSocket changedIP;
        private DatagramSocket changedPortIP;

        StunServerReceiverThread(DatagramSocket datagramSocket) {
            this.receiverSocket = datagramSocket;
            for (DatagramSocket socket : StunServer.this.sockets) {
                if (socket.getLocalPort() != this.receiverSocket.getLocalPort() && socket.getLocalAddress().equals(this.receiverSocket.getLocalAddress())) {
                    this.changedPort = socket;
                }
                if (socket.getLocalPort() == this.receiverSocket.getLocalPort() && !socket.getLocalAddress().equals(this.receiverSocket.getLocalAddress())) {
                    this.changedIP = socket;
                }
                if (socket.getLocalPort() == this.receiverSocket.getLocalPort() || socket.getLocalAddress().equals(this.receiverSocket.getLocalAddress())) continue;
                this.changedPortIP = socket;
            }
        }

        public void run() {
            block8: while (true) {
                try {
                    while (true) {
                        DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                        this.receiverSocket.receive(receive);
                        if (!StunServer.this.enabled) break block8;
                        logger.finest(this.receiverSocket.getLocalAddress().getHostAddress() + ":" + this.receiverSocket.getLocalPort() + " datagram received from " + receive.getAddress().getHostAddress() + ":" + receive.getPort());
                        MessageHeader receiveMH = MessageHeader.parseHeader(receive.getData());
                        try {
                            DatagramPacket send;
                            byte[] data;
                            SourceAddress sa;
                            receiveMH.parseAttributes(receive.getData());
                            if (receiveMH.getType() != MessageHeaderInterface.MessageHeaderType.BindingRequest) continue block8;
                            logger.config(this.receiverSocket.getLocalAddress().getHostAddress() + ":" + this.receiverSocket.getLocalPort() + " Binding Request received from " + receive.getAddress().getHostAddress() + ":" + receive.getPort());
                            ChangeRequest cr = (ChangeRequest)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ChangeRequest);
                            ResponseAddress ra = (ResponseAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ResponseAddress);
                            MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingResponse);
                            sendMH.setTransactionID(receiveMH.getTransactionID());
                            MappedAddress ma = new MappedAddress();
                            ma.setAddress(new Address(receive.getAddress().getAddress()));
                            ma.setPort(receive.getPort());
                            sendMH.addMessageAttribute(ma);
                            ChangedAddress ca = new ChangedAddress();
                            ca.setAddress(new Address(this.changedPortIP.getLocalAddress().getAddress()));
                            ca.setPort(this.changedPortIP.getLocalPort());
                            sendMH.addMessageAttribute(ca);
                            if (cr.isChangePort() && !cr.isChangeIP()) {
                                logger.finer("Change port received in Change Request attribute");
                                sa = new SourceAddress();
                                sa.setAddress(new Address(this.changedPort.getLocalAddress().getAddress()));
                                sa.setPort(this.changedPort.getLocalPort());
                                sendMH.addMessageAttribute(sa);
                                data = sendMH.getBytes();
                                send = new DatagramPacket(data, data.length);
                                if (ra != null) {
                                    send.setPort(ra.getPort());
                                    send.setAddress(ra.getAddress().getInetAddress());
                                } else {
                                    send.setPort(receive.getPort());
                                    send.setAddress(receive.getAddress());
                                }
                                this.changedPort.send(send);
                                logger.config(this.changedPort.getLocalAddress().getHostAddress() + ":" + this.changedPort.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort());
                                continue block8;
                            }
                            if (!cr.isChangePort() && cr.isChangeIP()) {
                                logger.finer("Change ip received in Change Request attribute");
                                sa = new SourceAddress();
                                sa.setAddress(new Address(this.changedIP.getLocalAddress().getAddress()));
                                sa.setPort(this.changedIP.getLocalPort());
                                sendMH.addMessageAttribute(sa);
                                data = sendMH.getBytes();
                                send = new DatagramPacket(data, data.length);
                                if (ra != null) {
                                    send.setPort(ra.getPort());
                                    send.setAddress(ra.getAddress().getInetAddress());
                                } else {
                                    send.setPort(receive.getPort());
                                    send.setAddress(receive.getAddress());
                                }
                                this.changedIP.send(send);
                                logger.config(this.changedIP.getLocalAddress().getHostAddress() + ":" + this.changedIP.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort());
                                continue block8;
                            }
                            if (!cr.isChangePort() && !cr.isChangeIP()) {
                                logger.finer("Nothing received in Change Request attribute");
                                sa = new SourceAddress();
                                sa.setAddress(new Address(this.receiverSocket.getLocalAddress().getAddress()));
                                sa.setPort(this.receiverSocket.getLocalPort());
                                sendMH.addMessageAttribute(sa);
                                data = sendMH.getBytes();
                                send = new DatagramPacket(data, data.length);
                                if (ra != null) {
                                    send.setPort(ra.getPort());
                                    send.setAddress(ra.getAddress().getInetAddress());
                                } else {
                                    send.setPort(receive.getPort());
                                    send.setAddress(receive.getAddress());
                                }
                                this.receiverSocket.send(send);
                                logger.config(this.receiverSocket.getLocalAddress().getHostAddress() + ":" + this.receiverSocket.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort());
                                continue block8;
                            }
                            if (!cr.isChangePort() || !cr.isChangeIP()) continue block8;
                            logger.finer("Change port and ip received in Change Request attribute");
                            sa = new SourceAddress();
                            sa.setAddress(new Address(this.changedPortIP.getLocalAddress().getAddress()));
                            sa.setPort(this.changedPortIP.getLocalPort());
                            sendMH.addMessageAttribute(sa);
                            data = sendMH.getBytes();
                            send = new DatagramPacket(data, data.length);
                            if (ra != null) {
                                send.setPort(ra.getPort());
                                send.setAddress(ra.getAddress().getInetAddress());
                            } else {
                                send.setPort(receive.getPort());
                                send.setAddress(receive.getAddress());
                            }
                            this.changedPortIP.send(send);
                            logger.config(this.changedPortIP.getLocalAddress().getHostAddress() + ":" + this.changedPortIP.getLocalPort() + " send Binding Response to " + send.getAddress().getHostAddress() + ":" + send.getPort());
                            continue block8;
                        }
                        catch (UnknownMessageAttributeException umae) {
                            umae.printStackTrace();
                            MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingErrorResponse);
                            sendMH.setTransactionID(receiveMH.getTransactionID());
                            UnknownAttribute ua = new UnknownAttribute();
                            ua.addAttribute(umae.getType());
                            sendMH.addMessageAttribute(ua);
                            byte[] data = sendMH.getBytes();
                            DatagramPacket send = new DatagramPacket(data, data.length);
                            send.setPort(receive.getPort());
                            send.setAddress(receive.getAddress());
                            this.receiverSocket.send(send);
                            logger.config(this.changedPortIP.getLocalAddress().getHostAddress() + ":" + this.changedPortIP.getLocalPort() + " send Binding Error Response to " + send.getAddress().getHostAddress() + ":" + send.getPort());
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    if (!StunServer.this.enabled) break;
                    ioe.printStackTrace();
                    break;
                }
                catch (MessageAttributeParsingException mape) {
                    if (!StunServer.this.enabled) break;
                    mape.printStackTrace();
                    break;
                }
                catch (MessageAttributeException mae) {
                    if (!StunServer.this.enabled) break;
                    mae.printStackTrace();
                    break;
                }
                catch (MessageHeaderParsingException mhpe) {
                    if (!StunServer.this.enabled) break;
                    mhpe.printStackTrace();
                    break;
                }
                catch (UtilityException ue) {
                    if (!StunServer.this.enabled) break;
                    ue.printStackTrace();
                    break;
                }
            }
        }
    }
}

