/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.jingle.IncomingJingleSession;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.OutgoingJingleSession;
import org.jivesoftware.smackx.jingle.listeners.CreatedJingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionRequestListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.BasicResolver;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.provider.JingleContentDescriptionProvider;
import org.jivesoftware.smackx.provider.JingleContentInfoProvider;
import org.jivesoftware.smackx.provider.JingleProvider;
import org.jivesoftware.smackx.provider.JingleTransportProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleManager
implements JingleSessionListener {
    final List<JingleSession> jingleSessions = new ArrayList<JingleSession>();
    private List<JingleSessionRequestListener> jingleSessionRequestListeners;
    private List<CreatedJingleSessionListener> creationListeners = new ArrayList<CreatedJingleSessionListener>();
    private XMPPConnection connection;
    private JingleMediaManager jingleMediaManager;
    private final JingleTransportManager jingleTransportManager;

    public JingleManager(XMPPConnection connection, JingleTransportManager jingleTransportManager, JingleMediaManager jingleMediaManager) {
        this.connection = connection;
        this.jingleTransportManager = jingleTransportManager;
        this.jingleMediaManager = jingleMediaManager;
        connection.getRoster().addRosterListener(new RosterListener(){

            public void entriesAdded(Collection addresses) {
            }

            public void entriesUpdated(Collection addresses) {
            }

            public void entriesDeleted(Collection addresses) {
            }

            public void presenceChanged(Presence presence) {
                if (!presence.isAvailable()) {
                    String xmppAddress = presence.getFrom();
                    JingleSession aux = null;
                    for (JingleSession jingleSession : JingleManager.this.jingleSessions) {
                        if (!jingleSession.getInitiator().equals(xmppAddress) && !jingleSession.getResponder().equals(xmppAddress)) continue;
                        aux = jingleSession;
                    }
                    if (aux != null) {
                        try {
                            aux.terminate();
                        }
                        catch (XMPPException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public JingleManager(XMPPConnection connection, JingleTransportManager jingleTransportManager) {
        this(connection, jingleTransportManager, null);
    }

    public JingleManager(XMPPConnection connection) {
        this(connection, new JingleTransportManager(){

            protected TransportResolver createResolver(JingleSession session) {
                return new BasicResolver();
            }
        });
    }

    public JingleManager(XMPPConnection connection, final TransportResolver resolver) {
        this(connection, new JingleTransportManager(){

            protected TransportResolver createResolver(JingleSession session) {
                return resolver;
            }
        });
    }

    public static synchronized void setServiceEnabled(XMPPConnection connection, boolean enabled) {
        if (JingleManager.isServiceEnabled(connection) == enabled) {
            return;
        }
        if (enabled) {
            ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).addFeature("http://jabber.org/protocol/jingle");
        } else {
            ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).removeFeature("http://jabber.org/protocol/jingle");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).includesFeature("http://jabber.org/protocol/jingle");
    }

    public static boolean isServiceEnabled(XMPPConnection connection, String userID) {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).discoverInfo(userID);
            return result.containsFeature("http://jabber.org/protocol/jingle");
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return false;
        }
    }

    public JingleTransportManager getJingleTransportManager() {
        return this.jingleTransportManager;
    }

    public JingleMediaManager getMediaManager() {
        return this.jingleMediaManager;
    }

    public void setMediaManager(JingleMediaManager jingleMediaManager) {
        this.jingleMediaManager = jingleMediaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (jingleSessionRequestListener != null) {
            if (this.jingleSessionRequestListeners == null) {
                this.initJingleSessionRequestListeners();
            }
            List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
            synchronized (list) {
                this.jingleSessionRequestListeners.add(jingleSessionRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (this.jingleSessionRequestListeners == null) {
            return;
        }
        List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
        synchronized (list) {
            this.jingleSessionRequestListeners.remove(jingleSessionRequestListener);
        }
    }

    public void addCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.add(createdJingleSessionListener);
    }

    public void removeCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.remove(createdJingleSessionListener);
    }

    public void triggerSessionCreated(JingleSession jingleSession) {
        this.jingleSessions.add(jingleSession);
        jingleSession.addListener(this);
        for (CreatedJingleSessionListener createdJingleSessionListener : this.creationListeners) {
            try {
                createdJingleSessionListener.sessionCreated(jingleSession);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sessionEstablished(PayloadType pt, TransportCandidate rc, TransportCandidate lc, JingleSession jingleSession) {
    }

    @Override
    public void sessionDeclined(String reason, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
        jingleSession.close();
        System.err.println("Declined:" + reason);
    }

    @Override
    public void sessionRedirected(String redirection, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosed(String reason, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosedOnError(XMPPException e, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionMediaReceived(JingleSession jingleSession, String participant) {
    }

    private void initJingleSessionRequestListeners() {
        PacketFilter initRequestFilter = new PacketFilter(){

            public boolean accept(Packet pin) {
                Jingle jin;
                IQ iq;
                return pin instanceof IQ && (iq = (IQ)pin).getType().equals(IQ.Type.SET) && iq instanceof Jingle && (jin = (Jingle)pin).getAction().equals((Object)Jingle.Action.SESSIONINITIATE);
            }
        };
        this.jingleSessionRequestListeners = new ArrayList<JingleSessionRequestListener>();
        this.connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                JingleManager.this.triggerSessionRequested((Jingle)packet);
            }
        }, initRequestFilter);
    }

    public void disconnectAllSessions() {
        List<JingleSession> sessions = this.jingleSessions.subList(0, this.jingleSessions.size());
        for (JingleSession jingleSession : sessions) {
            try {
                jingleSession.terminate();
            }
            catch (XMPPException e) {
                e.printStackTrace();
            }
        }
        sessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerSessionRequested(Jingle initJin) {
        JingleSessionRequestListener[] jingleSessionRequestListeners = null;
        List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
        synchronized (list) {
            jingleSessionRequestListeners = new JingleSessionRequestListener[this.jingleSessionRequestListeners.size()];
            this.jingleSessionRequestListeners.toArray(jingleSessionRequestListeners);
        }
        JingleSessionRequest request = new JingleSessionRequest(this, initJin);
        for (int i = 0; i < jingleSessionRequestListeners.length; ++i) {
            jingleSessionRequestListeners[i].sessionRequested(request);
        }
    }

    public OutgoingJingleSession createOutgoingJingleSession(String responder, List<PayloadType> payloadTypes) throws XMPPException {
        if (responder == null || StringUtils.parseName((String)responder).length() <= 0 || StringUtils.parseServer((String)responder).length() <= 0 || StringUtils.parseResource((String)responder).length() <= 0) {
            throw new IllegalArgumentException("The provided user id was not fully qualified");
        }
        OutgoingJingleSession session = this.jingleMediaManager != null ? new OutgoingJingleSession(this.connection, responder, payloadTypes, this.jingleTransportManager, this.jingleMediaManager) : new OutgoingJingleSession(this.connection, responder, payloadTypes, this.jingleTransportManager);
        this.triggerSessionCreated(session);
        return session;
    }

    public OutgoingJingleSession createOutgoingJingleSession(String responder) throws XMPPException {
        if (this.getMediaManager() == null) {
            return null;
        }
        return this.createOutgoingJingleSession(responder, this.getMediaManager().getPayloads());
    }

    IncomingJingleSession createIncomingJingleSession(JingleSessionRequest request, List<PayloadType> payloadTypes) throws XMPPException {
        if (request == null) {
            throw new NullPointerException("Received request cannot be null");
        }
        IncomingJingleSession session = this.jingleMediaManager != null ? new IncomingJingleSession(this.connection, request.getFrom(), payloadTypes, this.jingleTransportManager, this.jingleMediaManager, request) : new IncomingJingleSession(this.connection, request.getFrom(), payloadTypes, this.jingleTransportManager, request);
        this.triggerSessionCreated(session);
        return session;
    }

    IncomingJingleSession createIncomingJingleSession(JingleSessionRequest request) throws XMPPException {
        if (request == null) {
            throw new NullPointerException("JingleMediaManager is not defined");
        }
        if (this.jingleMediaManager != null) {
            return this.createIncomingJingleSession(request, this.jingleMediaManager.getPayloads());
        }
        return this.createIncomingJingleSession(request, null);
    }

    public JingleSession getSession(String jid) {
        for (JingleSession jingleSession : this.jingleSessions) {
            if (!(jingleSession instanceof OutgoingJingleSession ? jingleSession.getResponder().equals(jid) : jingleSession instanceof IncomingJingleSession && jingleSession.getInitiator().equals(jid))) continue;
            return jingleSession;
        }
        return null;
    }

    protected void rejectIncomingJingleSession(JingleSessionRequest request) {
        Jingle initiation = request.getJingle();
        IQ rejection = JingleSession.createError(initiation.getPacketID(), initiation.getFrom(), initiation.getTo(), 403, "Declined");
        this.connection.sendPacket((Packet)rejection);
    }

    static {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("jingle", "http://jabber.org/protocol/jingle", (Object)new JingleProvider());
        providerManager.addExtensionProvider("description", "http://jabber.org/protocol/jingle/description/audio", (Object)new JingleContentDescriptionProvider.Audio());
        providerManager.addExtensionProvider("description", "http://jabber.org/protocol/jingle/description/audio", (Object)new JingleContentDescriptionProvider.Audio());
        providerManager.addExtensionProvider("transport", "http://jabber.org/protocol/jingle/transport/ice", (Object)new JingleTransportProvider.Ice());
        providerManager.addExtensionProvider("transport", "http://jabber.org/protocol/jingle/transport/raw-udp", (Object)new JingleTransportProvider.RawUdp());
        providerManager.addExtensionProvider("busy", "http://jabber.org/protocol/jingle/info/audio", (Object)new JingleContentInfoProvider.Audio.Busy());
        providerManager.addExtensionProvider("hold", "http://jabber.org/protocol/jingle/info/audio", (Object)new JingleContentInfoProvider.Audio.Hold());
        providerManager.addExtensionProvider("mute", "http://jabber.org/protocol/jingle/info/audio", (Object)new JingleContentInfoProvider.Audio.Mute());
        providerManager.addExtensionProvider("queued", "http://jabber.org/protocol/jingle/info/audio", (Object)new JingleContentInfoProvider.Audio.Queued());
        providerManager.addExtensionProvider("ringing", "http://jabber.org/protocol/jingle/info/audio", (Object)new JingleContentInfoProvider.Audio.Ringing());
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                JingleManager.setServiceEnabled(connection, true);
            }
        });
    }
}

