/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionStateListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.media.ContentInfo;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.MediaReceivedListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContentDescription;
import org.jivesoftware.smackx.packet.JingleContentInfo;
import org.jivesoftware.smackx.packet.JingleError;
import org.jivesoftware.smackx.packet.JingleTransport;

public abstract class JingleSession
extends JingleNegotiator
implements MediaReceivedListener {
    private static final HashMap sessions = new HashMap();
    private static final Random randomGenerator = new Random();
    private String initiator;
    private String responder;
    private String sid;
    private MediaNegotiator mediaNeg = null;
    private TransportNegotiator transNeg = null;
    PacketListener packetListener;
    PacketFilter packetFilter;
    protected JingleMediaManager jingleMediaManager = null;
    protected JingleMediaSession jingleMediaSession = null;
    private boolean closed = false;
    private List<JingleSessionStateListener> stateListeners = new ArrayList<JingleSessionStateListener>();

    protected JingleSession(XMPPConnection conn, String initiator, String responder, String sessionid, JingleMediaManager jingleMediaManager) {
        super(conn);
        this.initiator = initiator;
        this.responder = responder;
        this.sid = sessionid;
        this.jingleMediaManager = jingleMediaManager;
        this.registerInstance();
        this.installConnectionListeners(conn);
    }

    protected JingleSession(XMPPConnection conn, String initiator, String responder) {
        this(conn, initiator, responder, null, null);
    }

    protected JingleSession(XMPPConnection conn, String initiator, String responder, JingleMediaManager jingleMediaManager) {
        this(conn, initiator, responder, null, jingleMediaManager);
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public JingleMediaManager getMediaManager() {
        return this.jingleMediaManager;
    }

    public void setMediaManager(JingleMediaManager jingleMediaManager) {
        this.jingleMediaManager = jingleMediaManager;
    }

    public JingleMediaSession getJingleMediaSession() {
        return this.jingleMediaSession;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setResponder(String responder) {
        this.responder = responder;
    }

    public String getSid() {
        return this.sid;
    }

    protected void setSid(String sessionId) {
        this.sid = sessionId;
    }

    protected static String generateSessionId() {
        return String.valueOf(Math.abs(randomGenerator.nextLong()));
    }

    protected MediaNegotiator getMediaNeg() {
        return this.mediaNeg;
    }

    protected void setMediaNeg(MediaNegotiator mediaNeg) {
        this.destroyMediaNeg();
        this.mediaNeg = mediaNeg;
    }

    protected void destroyMediaNeg() {
        if (this.mediaNeg != null) {
            this.mediaNeg.close();
            this.mediaNeg = null;
        }
    }

    public void addStateListener(JingleSessionStateListener listener) {
        this.stateListeners.add(listener);
    }

    public void removedStateListener(JingleSessionStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void removeAllStateListeners() {
        this.stateListeners.clear();
    }

    protected void setState(JingleNegotiator.State newState) {
        boolean proceed = true;
        JingleNegotiator.State old = this.getState();
        for (JingleSessionStateListener listener : this.stateListeners) {
            try {
                listener.beforeChange(old, newState);
            }
            catch (JingleNegotiator.JingleException e) {
                proceed = false;
            }
        }
        if (proceed) {
            super.setState(newState);
        }
        for (JingleSessionStateListener listener : this.stateListeners) {
            listener.afterChanged(old, this.getState());
        }
    }

    protected TransportNegotiator getTransportNeg() {
        return this.transNeg;
    }

    protected void setTransportNeg(TransportNegotiator transNeg) {
        this.destroyTransportNeg();
        this.transNeg = transNeg;
    }

    protected void destroyTransportNeg() {
        if (this.transNeg != null) {
            this.transNeg.close();
            this.transNeg = null;
        }
    }

    public boolean isFullyEstablished() {
        if (!this.isValid()) {
            return false;
        }
        return this.getTransportNeg().isFullyEstablished() && this.getMediaNeg().isFullyEstablished();
    }

    public boolean isValid() {
        return this.mediaNeg != null && this.transNeg != null && this.sid != null && this.initiator != null;
    }

    public IQ dispatchIncomingPacket(IQ iq, String id) throws XMPPException {
        Jingle jout = null;
        if (this.invalidState()) {
            throw new IllegalStateException("Illegal state in dispatch packet in Session manager.");
        }
        if (iq == null) {
            jout = this.getState().eventInvite();
        } else if (iq.getType().equals(IQ.Type.ERROR)) {
            this.getState().eventError(iq);
        } else if (iq.getType().equals(IQ.Type.RESULT)) {
            if (this.isExpectedId(iq.getPacketID())) {
                jout = this.getState().eventAck(iq);
                this.removeExpectedId(iq.getPacketID());
            }
        } else if (iq instanceof Jingle) {
            Jingle jin = (Jingle)iq;
            Jingle.Action action = jin.getAction();
            if (action != null) {
                if (action.equals((Object)Jingle.Action.SESSIONACCEPT)) {
                    jout = this.getState().eventAccept(jin);
                } else if (action.equals((Object)Jingle.Action.SESSIONINFO)) {
                    jout = this.getState().eventInfo(jin);
                } else if (action.equals((Object)Jingle.Action.SESSIONINITIATE)) {
                    jout = this.getState().eventInitiate(jin);
                } else if (action.equals((Object)Jingle.Action.SESSIONREDIRECT)) {
                    jout = this.getState().eventRedirect(jin);
                } else if (action.equals((Object)Jingle.Action.SESSIONTERMINATE)) {
                    jout = this.getState().eventTerminate(jin);
                }
            } else {
                jout = this.errorMalformedStanza(iq);
            }
        }
        if (jout != null) {
            this.addExpectedId(jout.getPacketID());
        }
        return jout;
    }

    public synchronized IQ respond(IQ iq) throws XMPPException {
        Jingle response = null;
        if (this.isValid()) {
            String responseId = null;
            IQ sessionResponse = null;
            IQ descriptionResponse = null;
            IQ transportResponse = null;
            try {
                sessionResponse = this.dispatchIncomingPacket(iq, null);
                if (sessionResponse != null) {
                    responseId = sessionResponse.getPacketID();
                }
                if (this.mediaNeg != null) {
                    descriptionResponse = this.mediaNeg.dispatchIncomingPacket(iq, responseId);
                }
                if (this.transNeg != null) {
                    transportResponse = this.transNeg.dispatchIncomingPacket(iq, responseId);
                }
                this.sendAck(iq);
                response = this.sendJingleParts(iq, (Jingle)sessionResponse, (Jingle)descriptionResponse, (Jingle)transportResponse);
            }
            catch (JingleNegotiator.JingleException e) {
                JingleError error = e.getError();
                if (error != null) {
                    this.sendFormattedError(iq, error);
                }
                this.triggerSessionClosedOnError(e);
            }
        }
        return response;
    }

    private Jingle sendJingleParts(IQ iq, Jingle jSes, Jingle jDesc, Jingle jTrans) {
        Jingle response = null;
        if (jSes != null) {
            jSes.addDescriptions(jDesc.getDescriptionsList());
            jSes.addTransports(jTrans.getTransportsList());
            response = this.sendFormattedJingle(iq, jSes);
        } else {
            if (jDesc != null) {
                response = this.sendFormattedJingle(iq, jDesc);
            }
            if (jTrans != null) {
                response = this.sendFormattedJingle(iq, jTrans);
            }
        }
        return response;
    }

    public IQ sendFormattedError(IQ iq, JingleError error) {
        IQ perror = null;
        if (error != null) {
            perror = JingleSession.createIQ(this.getSid(), iq.getFrom(), iq.getTo(), IQ.Type.ERROR);
            perror.setPacketID(iq.getPacketID());
            perror.addExtension((PacketExtension)error);
            this.getConnection().sendPacket((Packet)perror);
            System.err.println(error.toXML());
        }
        return perror;
    }

    public Jingle sendFormattedJingle(IQ iq, Jingle jout) {
        if (jout != null) {
            String other;
            if (jout.getInitiator() == null) {
                jout.setInitiator(this.getInitiator());
            }
            if (jout.getResponder() == null) {
                jout.setResponder(this.getResponder());
            }
            if (jout.getSid() == null) {
                jout.setSid(this.getSid());
            }
            String me = this.getConnection().getUser();
            String string = other = this.getResponder().equals(me) ? this.getInitiator() : this.getResponder();
            if (jout.getTo() == null) {
                if (iq != null) {
                    jout.setTo(iq.getFrom());
                } else {
                    jout.setTo(other);
                }
            }
            if (jout.getFrom() == null) {
                if (iq != null) {
                    jout.setFrom(iq.getTo());
                } else {
                    jout.setFrom(me);
                }
            }
            this.getConnection().sendPacket((Packet)jout);
        }
        return jout;
    }

    public Jingle sendFormattedJingle(Jingle jout) {
        return this.sendFormattedJingle(null, jout);
    }

    protected IQ errorMalformedStanza(IQ iq) {
        return JingleSession.createError(iq.getPacketID(), iq.getFrom(), this.getConnection().getUser(), 400, "Bad Request");
    }

    protected Jingle sendAcceptIfFullyEstablished() {
        Jingle result = null;
        if (this.isFullyEstablished()) {
            Jingle jout = new Jingle(Jingle.Action.SESSIONACCEPT);
            jout.setType(IQ.Type.SET);
            result = this.sendFormattedJingle(jout);
        }
        return result;
    }

    public IQ sendAck(IQ iq) {
        IQ result = null;
        if (iq != null && iq.getType().equals(IQ.Type.SET)) {
            IQ ack = JingleSession.createIQ(iq.getPacketID(), iq.getFrom(), iq.getTo(), IQ.Type.RESULT);
            this.getConnection().sendPacket((Packet)ack);
            result = ack;
        }
        return result;
    }

    public synchronized void sendContentInfo(ContentInfo ci) {
        if (this.isValid()) {
            this.sendFormattedJingle(new Jingle(new JingleContentInfo(ci)));
        }
    }

    protected PayloadType.Audio getAcceptedAudioPayloadType(Jingle jin) throws XMPPException {
        PayloadType.Audio acceptedPayloadType = null;
        ArrayList jda = jin.getDescriptionsList();
        if (jin.getAction().equals((Object)Jingle.Action.SESSIONACCEPT)) {
            if (jda.size() > 1) {
                throw new XMPPException("Unsupported feature: the number of accepted content descriptions is greater than 1.");
            }
            if (jda.size() == 1) {
                JingleContentDescription jd = (JingleContentDescription)jda.get(0);
                if (jd.getJinglePayloadTypesCount() > 1) {
                    throw new XMPPException("Unsupported feature: the number of accepted payload types is greater than 1.");
                }
                if (jd.getJinglePayloadTypesCount() == 1) {
                    JingleContentDescription.JinglePayloadType jpt = (JingleContentDescription.JinglePayloadType)jd.getJinglePayloadTypesList().get(0);
                    acceptedPayloadType = (PayloadType.Audio)jpt.getPayloadType();
                }
            }
        }
        return acceptedPayloadType;
    }

    protected TransportCandidate getAcceptedLocalCandidate(Jingle jin) throws XMPPException {
        ArrayList jta = jin.getTransportsList();
        TransportCandidate acceptedLocalCandidate = null;
        if (jin.getAction().equals((Object)Jingle.Action.SESSIONACCEPT)) {
            if (jta.size() > 1) {
                throw new XMPPException("Unsupported feature: the number of accepted transports is greater than 1.");
            }
            if (jta.size() == 1) {
                JingleTransport jt = (JingleTransport)jta.get(0);
                if (jt.getCandidatesCount() > 1) {
                    throw new XMPPException("Unsupported feature: the number of accepted transport candidates is greater than 1.");
                }
                if (jt.getCandidatesCount() == 1) {
                    JingleTransport.JingleTransportCandidate jtc = (JingleTransport.JingleTransportCandidate)jt.getCandidatesList().get(0);
                    acceptedLocalCandidate = jtc.getMediaTransport();
                }
            }
        }
        return acceptedLocalCandidate;
    }

    public int hashCode() {
        return Jingle.getSessionHash(this.getSid(), this.getInitiator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JingleSession other = (JingleSession)obj;
        if (this.initiator == null) {
            if (other.initiator != null) {
                return false;
            }
        } else if (!this.initiator.equals(other.initiator)) {
            // empty if block
        }
        if (this.responder == null ? other.responder != null : !this.responder.equals(other.responder)) {
            return false;
        }
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInstanceFor(XMPPConnection connection) {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstance() {
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            sessions.put(this.getConnection(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JingleSession getInstanceFor(XMPPConnection con) {
        if (con == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        JingleSession result = null;
        HashMap hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(con)) {
                result = (JingleSession)sessions.get(con);
            }
        }
        return result;
    }

    private void installConnectionListeners(final XMPPConnection connection) {
        if (connection != null) {
            connection.addConnectionListener(new ConnectionListener(){

                public void connectionClosed() {
                    JingleSession.this.unregisterInstanceFor(connection);
                }

                public void connectionClosedOnError(Exception e) {
                    JingleSession.this.unregisterInstanceFor(connection);
                }

                public void reconnectingIn(int i) {
                }

                public void reconnectionSuccessful() {
                }

                public void reconnectionFailed(Exception exception) {
                }
            });
        }
    }

    protected void removePacketListener() {
        if (this.packetListener != null) {
            this.getConnection().removePacketListener(this.packetListener);
            System.out.println("REMOVE PACKET LISTENER");
        }
    }

    protected void updatePacketListener() {
        this.removePacketListener();
        System.out.println("UpdatePacketListener");
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                try {
                    JingleSession.this.respond((IQ)packet);
                }
                catch (XMPPException e) {
                    e.printStackTrace();
                }
            }
        };
        this.packetFilter = new PacketFilter(){

            public boolean accept(Packet packet) {
                if (packet instanceof IQ) {
                    String other;
                    IQ iq = (IQ)packet;
                    String me = JingleSession.this.getConnection().getUser();
                    if (!iq.getTo().equals(me)) {
                        return false;
                    }
                    String string = other = JingleSession.this.getResponder().equals(me) ? JingleSession.this.getInitiator() : JingleSession.this.getResponder();
                    if (iq.getFrom() == null || !iq.getFrom().equals(other == null ? "" : other)) {
                        return false;
                    }
                    if (iq instanceof Jingle) {
                        Jingle jin = (Jingle)iq;
                        System.out.println("Jingle: " + iq.toXML());
                        String sid = jin.getSid();
                        if (sid == null || !sid.equals(JingleSession.this.getSid())) {
                            System.out.println("Ignored Jingle(SID) " + sid + "|" + JingleSession.this.getSid() + " :" + iq.toXML());
                            return false;
                        }
                        String ini = jin.getInitiator();
                        if (!ini.equals(JingleSession.this.getInitiator())) {
                            System.out.println("Ignored Jingle(INI): " + iq.toXML());
                            return false;
                        }
                    } else {
                        if (iq.getType().equals(IQ.Type.SET)) {
                            System.out.println("Ignored Jingle(TYPE): " + iq.toXML());
                            return false;
                        }
                        if (iq.getType().equals(IQ.Type.GET)) {
                            System.out.println("Ignored Jingle(TYPE): " + iq.toXML());
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        this.getConnection().addPacketListener(this.packetListener, this.packetFilter);
    }

    public void addMediaListener(JingleMediaListener li) {
        if (this.getMediaNeg() != null) {
            this.getMediaNeg().addListener(li);
        }
    }

    public void removeMediaListener(JingleMediaListener li) {
        if (this.getMediaNeg() != null) {
            this.getMediaNeg().removeListener(li);
        }
    }

    public void addTransportListener(JingleTransportListener li) {
        if (this.getTransportNeg() != null) {
            this.getTransportNeg().addListener(li);
        }
    }

    public void removeTransportListener(JingleTransportListener li) {
        if (this.getTransportNeg() != null) {
            this.getTransportNeg().removeListener(li);
        }
    }

    protected void triggerSessionClosed(String reason) {
        for (TransportCandidate candidate : this.getTransportNeg().getOfferedCandidates()) {
            candidate.removeCandidateEcho();
        }
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionClosed(reason, this);
        }
        this.close();
        if (this.jingleMediaSession != null) {
            this.jingleMediaSession.stopTrasmit();
            this.jingleMediaSession.stopReceive();
        }
    }

    protected void triggerSessionClosedOnError(XMPPException exc) {
        for (TransportCandidate candidate : this.getTransportNeg().getOfferedCandidates()) {
            candidate.removeCandidateEcho();
        }
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionClosedOnError(exc, this);
        }
        this.close();
        if (this.jingleMediaSession != null) {
            this.jingleMediaSession.stopTrasmit();
            this.jingleMediaSession.stopReceive();
        }
    }

    protected void triggerSessionEstablished(PayloadType pt, TransportCandidate rc, TransportCandidate lc) {
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionEstablished(pt, rc, lc, this);
        }
        if (this.jingleMediaManager != null) {
            rc.removeCandidateEcho();
            lc.removeCandidateEcho();
            this.jingleMediaSession = this.jingleMediaManager.createMediaSession(pt, rc, lc, this);
            this.jingleMediaSession.addMediaReceivedListener(this);
            if (this.jingleMediaSession != null) {
                this.jingleMediaSession.startTrasmit();
                this.jingleMediaSession.startReceive();
                for (TransportCandidate candidate : this.getTransportNeg().getOfferedCandidates()) {
                    candidate.removeCandidateEcho();
                }
            }
        }
    }

    protected void triggerMediaReceived(String participant) {
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionMediaReceived(this, participant);
        }
    }

    protected void triggerSessionRedirect(String arg) {
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionRedirected(arg, this);
        }
    }

    protected void triggerSessionDeclined(String reason) {
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionDeclined(reason, this);
        }
        for (TransportCandidate candidate : this.getTransportNeg().getOfferedCandidates()) {
            candidate.removeCandidateEcho();
        }
    }

    public abstract void start(JingleSessionRequest var1) throws XMPPException;

    public void terminate() throws XMPPException {
        this.terminate("Closed Locally");
    }

    public void terminate(String reason) throws XMPPException {
        if (this.isClosed()) {
            return;
        }
        System.out.println("State: " + this.getState());
        Jingle jout = new Jingle(Jingle.Action.SESSIONTERMINATE);
        jout.setType(IQ.Type.SET);
        this.sendFormattedJingle(jout);
        this.triggerSessionClosed(reason);
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.destroyMediaNeg();
        this.destroyTransportNeg();
        this.removePacketListener();
        System.out.println("Negotiation Closed: " + this.getConnection().getUser() + " " + this.sid);
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static IQ createIQ(String ID, String to, String from, IQ.Type type) {
        IQ iqPacket = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iqPacket.setPacketID(ID);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        iqPacket.setType(type);
        return iqPacket;
    }

    public static IQ createError(String ID, String to, String from, int errCode, String errStr) {
        IQ iqError = JingleSession.createIQ(ID, to, from, IQ.Type.ERROR);
        XMPPError error = new XMPPError(new XMPPError.Condition(errStr));
        iqError.setError(error);
        System.out.println("Created Error Packet:" + iqError.toXML());
        return iqError;
    }

    public void mediaReceived(String participant) {
        this.triggerMediaReceived(participant);
    }
}

