/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.IncomingJingleSession;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.packet.Jingle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleSessionRequest {
    private final Jingle jingle;
    private final JingleManager manager;

    public JingleSessionRequest(JingleManager manager, Jingle jingle) {
        this.manager = manager;
        this.jingle = jingle;
    }

    public String getFrom() {
        return this.jingle.getFrom();
    }

    public String getSessionID() {
        return this.jingle.getSid();
    }

    public Jingle getJingle() {
        return this.jingle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IncomingJingleSession accept(List<PayloadType> pts) throws XMPPException {
        IncomingJingleSession session = null;
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            session = this.manager.createIncomingJingleSession(this, pts);
            session.setInitialSessionRequest(this);
            session.setSid(this.getSessionID());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IncomingJingleSession accept() throws XMPPException {
        IncomingJingleSession session = null;
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            session = this.manager.createIncomingJingleSession(this);
            session.setInitialSessionRequest(this);
            session.setSid(this.getSessionID());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reject() {
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            this.manager.rejectIncomingJingleSession(this);
        }
    }
}

