/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.media;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContentDescription;
import org.jivesoftware.smackx.packet.JingleError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaNegotiator
extends JingleNegotiator {
    private final JingleSession session;
    private final List<PayloadType> localAudioPts = new ArrayList<PayloadType>();
    private final List<PayloadType> remoteAudioPts = new ArrayList<PayloadType>();
    private PayloadType.Audio bestCommonAudioPt;
    private final Inviting inviting;
    private final Accepting accepting;
    private final Pending pending;
    private final Active active;

    public MediaNegotiator(JingleSession js, List<PayloadType> pts) {
        super(js.getConnection());
        this.session = js;
        this.bestCommonAudioPt = null;
        if (pts != null && pts.size() > 0) {
            this.localAudioPts.addAll(pts);
        }
        this.inviting = new Inviting(this);
        this.accepting = new Accepting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IQ dispatchIncomingPacket(IQ iq, String id) throws XMPPException {
        Jingle jout = null;
        if (this.invalidState()) {
            if (iq == null) {
                this.setState(this.inviting);
                jout = this.getState().eventInvite();
            } else {
                if (!(iq instanceof Jingle)) throw new IllegalStateException("Invitation IQ received is not a Jingle packet in Media negotiator.");
                this.setState(this.accepting);
                jout = this.getState().eventInitiate((Jingle)iq);
            }
        } else {
            Jingle jin;
            Jingle.Action action;
            if (iq == null) {
                return null;
            }
            if (iq.getType().equals(IQ.Type.ERROR)) {
                this.getState().eventError(iq);
            } else if (iq.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iq.getPacketID())) {
                    jout = this.getState().eventAck(iq);
                    this.removeExpectedId(iq.getPacketID());
                }
            } else if (iq instanceof Jingle && (action = (jin = (Jingle)iq).getAction()) != null) {
                if (action.equals((Object)Jingle.Action.CONTENTACCEPT)) {
                    jout = this.getState().eventAccept(jin);
                } else if (action.equals((Object)Jingle.Action.CONTENTDECLINE)) {
                    jout = this.getState().eventDecline(jin);
                } else if (action.equals((Object)Jingle.Action.DESCRIPTIONINFO)) {
                    jout = this.getState().eventInfo(jin);
                } else if (action.equals((Object)Jingle.Action.CONTENTMODIFY)) {
                    jout = this.getState().eventModify(jin);
                }
            }
        }
        if (id != null) {
            this.addExpectedId(id);
            return jout;
        } else {
            if (jout == null) return jout;
            this.addExpectedId(jout.getPacketID());
        }
        return jout;
    }

    public boolean isEstablished() {
        return this.getBestCommonAudioPt() != null;
    }

    public boolean isFullyEstablished() {
        return this.isEstablished() && this.getState() == this.active;
    }

    private PayloadType.Audio calculateBestCommonAudioPt(List remoteAudioPts) {
        ArrayList<PayloadType> commonAudioPtsHere = new ArrayList<PayloadType>();
        ArrayList commonAudioPtsThere = new ArrayList();
        PayloadType.Audio result = null;
        if (!remoteAudioPts.isEmpty()) {
            commonAudioPtsHere.addAll(this.localAudioPts);
            commonAudioPtsHere.retainAll(remoteAudioPts);
            commonAudioPtsThere.addAll(remoteAudioPts);
            commonAudioPtsThere.retainAll(this.localAudioPts);
            if (!commonAudioPtsHere.isEmpty() && !commonAudioPtsThere.isEmpty()) {
                if (this.session.getInitiator().equals(this.session.getConnection().getUser())) {
                    PayloadType.Audio bestPtHere = null;
                    PayloadType payload = this.session.getMediaManager().getPreferredPayloadType();
                    if (payload != null && payload instanceof PayloadType.Audio && commonAudioPtsHere.contains(payload)) {
                        bestPtHere = (PayloadType.Audio)payload;
                    }
                    if (bestPtHere == null) {
                        for (PayloadType payloadType : commonAudioPtsHere) {
                            if (!(payloadType instanceof PayloadType.Audio)) continue;
                            bestPtHere = (PayloadType.Audio)payloadType;
                            break;
                        }
                    }
                    result = bestPtHere;
                } else {
                    PayloadType.Audio bestPtThere = null;
                    for (PayloadType payloadType : commonAudioPtsThere) {
                        if (!(payloadType instanceof PayloadType.Audio)) continue;
                        bestPtThere = (PayloadType.Audio)payloadType;
                        break;
                    }
                    result = bestPtThere;
                }
            }
        }
        return result;
    }

    private List obtainPayloads(Jingle jin) {
        ArrayList result = new ArrayList();
        Iterator iDescr = jin.getDescriptions();
        while (iDescr.hasNext()) {
            JingleContentDescription.Audio descr = (JingleContentDescription.Audio)iDescr.next();
            if (descr == null) continue;
            result.clear();
            result.addAll(descr.getAudioPayloadTypesList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteAudioPayloadType(PayloadType.Audio pt) {
        if (pt != null) {
            List<PayloadType> list = this.remoteAudioPts;
            synchronized (list) {
                this.remoteAudioPts.add(pt);
            }
        }
    }

    private Jingle getAudioPayloadTypesOffer() {
        JingleContentDescription.Audio audioDescr = new JingleContentDescription.Audio();
        audioDescr.addAudioPayloadTypes(this.localAudioPts);
        return new Jingle(audioDescr);
    }

    private Jingle createAcceptMessage() {
        Jingle jout = null;
        jout = new Jingle(Jingle.Action.CONTENTACCEPT);
        jout.addDescription(new JingleContentDescription.Audio(new JingleContentDescription.JinglePayloadType.Audio(this.bestCommonAudioPt)));
        return jout;
    }

    public PayloadType.Audio getBestCommonAudioPt() {
        return this.bestCommonAudioPt;
    }

    protected void triggerMediaEstablished(PayloadType bestPt) {
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleMediaListener)) continue;
            JingleMediaListener mli = (JingleMediaListener)li;
            mli.mediaEstablished(bestPt);
        }
    }

    protected void triggerMediaClosed(PayloadType currPt) {
        ArrayList listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleMediaListener)) continue;
            JingleMediaListener mli = (JingleMediaListener)li;
            mli.mediaClosed(currPt);
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public class Active
    extends JingleNegotiator.State {
        public Active(MediaNegotiator neg) {
            super(neg);
        }

        public void eventEnter() {
            MediaNegotiator.this.triggerMediaEstablished(MediaNegotiator.this.getBestCommonAudioPt());
            System.err.println("BS:" + MediaNegotiator.this.getBestCommonAudioPt().getName());
            super.eventEnter();
        }

        public void eventExit() {
            MediaNegotiator.this.triggerMediaClosed(MediaNegotiator.this.getBestCommonAudioPt());
            super.eventExit();
        }
    }

    public class Pending
    extends JingleNegotiator.State {
        public Pending(MediaNegotiator neg) {
            super(neg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Jingle eventInfo(Jingle jin) throws JingleNegotiator.JingleException {
            PayloadType.Audio oldBestCommonAudioPt = MediaNegotiator.this.bestCommonAudioPt;
            Jingle response = null;
            boolean ptChange = false;
            List offeredPayloads = MediaNegotiator.this.obtainPayloads(jin);
            if (!offeredPayloads.isEmpty()) {
                List list = MediaNegotiator.this.remoteAudioPts;
                synchronized (list) {
                    MediaNegotiator.this.remoteAudioPts.clear();
                    MediaNegotiator.this.remoteAudioPts.addAll(offeredPayloads);
                }
                MediaNegotiator.this.bestCommonAudioPt = MediaNegotiator.this.calculateBestCommonAudioPt(MediaNegotiator.this.remoteAudioPts);
                if (MediaNegotiator.this.bestCommonAudioPt != null) {
                    boolean bl = ptChange = !MediaNegotiator.this.bestCommonAudioPt.equals(oldBestCommonAudioPt);
                    if (oldBestCommonAudioPt == null || ptChange) {
                        response = MediaNegotiator.this.createAcceptMessage();
                    }
                } else {
                    throw new JingleNegotiator.JingleException(JingleError.NO_COMMON_PAYLOAD);
                }
            }
            return response;
        }

        public Jingle eventAccept(Jingle jin) throws JingleNegotiator.JingleException {
            List offeredPayloads = new ArrayList();
            Jingle response = null;
            if (MediaNegotiator.this.bestCommonAudioPt == null) {
                MediaNegotiator.this.bestCommonAudioPt = MediaNegotiator.this.calculateBestCommonAudioPt(MediaNegotiator.this.remoteAudioPts);
                response = MediaNegotiator.this.createAcceptMessage();
            }
            if (!(offeredPayloads = MediaNegotiator.this.obtainPayloads(jin)).isEmpty()) {
                if (offeredPayloads.size() == 1) {
                    PayloadType.Audio agreedCommonAudioPt = (PayloadType.Audio)offeredPayloads.get(0);
                    if (MediaNegotiator.this.bestCommonAudioPt != null && !agreedCommonAudioPt.equals(MediaNegotiator.this.bestCommonAudioPt)) {
                        throw new JingleNegotiator.JingleException(JingleError.NEGOTIATION_ERROR);
                    }
                } else if (offeredPayloads.size() > 1) {
                    throw new JingleNegotiator.JingleException(JingleError.MALFORMED_STANZA);
                }
            }
            return response;
        }

        public Jingle eventDecline(Jingle inJingle) throws JingleNegotiator.JingleException {
            MediaNegotiator.this.triggerMediaClosed(MediaNegotiator.this.getBestCommonAudioPt());
            throw new JingleNegotiator.JingleException();
        }

        public void eventError(IQ iq) throws XMPPException {
            MediaNegotiator.this.triggerMediaClosed(MediaNegotiator.this.getBestCommonAudioPt());
            super.eventError(iq);
        }

        public Jingle eventAck(IQ iq) {
            if (MediaNegotiator.this.isEstablished()) {
                MediaNegotiator.this.setState(MediaNegotiator.this.active);
                return null;
            }
            return null;
        }
    }

    public class Accepting
    extends JingleNegotiator.State {
        public Accepting(MediaNegotiator neg) {
            super(neg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Jingle eventInitiate(Jingle jin) {
            List list = MediaNegotiator.this.remoteAudioPts;
            synchronized (list) {
                MediaNegotiator.this.remoteAudioPts.addAll(MediaNegotiator.this.obtainPayloads(jin));
            }
            return MediaNegotiator.this.getAudioPayloadTypesOffer();
        }

        public Jingle eventAck(IQ iq) throws XMPPException {
            Jingle response = null;
            if (!MediaNegotiator.this.remoteAudioPts.isEmpty()) {
                MediaNegotiator.this.bestCommonAudioPt = MediaNegotiator.this.calculateBestCommonAudioPt(MediaNegotiator.this.remoteAudioPts);
                if (MediaNegotiator.this.bestCommonAudioPt == null) {
                    throw new JingleNegotiator.JingleException(JingleError.NO_COMMON_PAYLOAD);
                }
                response = MediaNegotiator.this.createAcceptMessage();
                MediaNegotiator.this.setState(MediaNegotiator.this.pending);
            }
            return response;
        }
    }

    public class Inviting
    extends JingleNegotiator.State {
        public Inviting(MediaNegotiator neg) {
            super(neg);
        }

        public Jingle eventInvite() {
            return MediaNegotiator.this.getAudioPayloadTypesOffer();
        }

        public Jingle eventAck(IQ iq) {
            MediaNegotiator.this.setState(MediaNegotiator.this.pending);
            return null;
        }
    }
}

