/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.jmf;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.IncomingJingleSession;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.OutgoingJingleSession;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionRequestListener;
import org.jivesoftware.smackx.jingle.mediaimpl.jmf.JmfMediaManager;
import org.jivesoftware.smackx.jingle.nat.ICETransportManager;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;

public class Demo
extends JFrame {
    private JingleTransportManager transportManager = null;
    private XMPPConnection xmppConnection = null;
    private String server = null;
    private String user = null;
    private String pass = null;
    private JingleManager jm = null;
    private IncomingJingleSession incoming = null;
    private OutgoingJingleSession outgoing = null;
    private JTextField jid = new JTextField(30);

    public Demo(String server, String user, String pass) {
        this.server = server;
        this.user = user;
        this.pass = pass;
        this.xmppConnection = new XMPPConnection(server);
        try {
            this.xmppConnection.connect();
            this.xmppConnection.login(user, pass);
            this.initialize();
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        ICETransportManager icetm0 = new ICETransportManager(this.xmppConnection, "jivesoftware.com", 3478);
        this.jm = new JingleManager(this.xmppConnection, icetm0, new JmfMediaManager());
        this.jm.addCreationListener(icetm0);
        this.jm.addJingleSessionRequestListener(new JingleSessionRequestListener(){

            public void sessionRequested(JingleSessionRequest request) {
                if (Demo.this.incoming != null) {
                    return;
                }
                try {
                    Demo.this.incoming = request.accept();
                    Demo.this.incoming.start();
                }
                catch (XMPPException e) {
                    e.printStackTrace();
                }
            }
        });
        this.createGUI();
    }

    public void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.jid);
        jPanel.add(new JButton(new AbstractAction("Call"){

            public void actionPerformed(ActionEvent e) {
                if (Demo.this.outgoing != null) {
                    return;
                }
                try {
                    Demo.this.outgoing = Demo.this.jm.createOutgoingJingleSession(Demo.this.jid.getText());
                    Demo.this.outgoing.start();
                }
                catch (XMPPException e1) {
                    e1.printStackTrace();
                }
            }
        }));
        jPanel.add(new JButton(new AbstractAction("Hangup"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                if (Demo.this.outgoing != null) {
                    try {
                        Demo.this.outgoing.terminate();
                    }
                    catch (XMPPException e1) {
                        e1.printStackTrace();
                    }
                    finally {
                        Demo.this.outgoing = null;
                    }
                }
                if (Demo.this.incoming != null) {
                    try {
                        Demo.this.incoming.terminate();
                    }
                    catch (XMPPException e1) {
                        e1.printStackTrace();
                    }
                    finally {
                        Demo.this.incoming = null;
                    }
                }
            }
        }));
        this.add(jPanel);
    }

    public static void main(String[] args) {
        Demo demo = null;
        if (args.length > 2) {
            demo = new Demo(args[0], args[1], args[2]);
            demo.pack();
            demo.setVisible(true);
            demo.setDefaultCloseOperation(3);
        }
    }
}

