/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.jspeex;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.mediaimpl.JMFInit;
import org.jivesoftware.smackx.jingle.mediaimpl.jspeex.AudioMediaSession;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeexMediaManager
extends JingleMediaManager {
    private List<PayloadType> payloads = new ArrayList<PayloadType>();

    public SpeexMediaManager() {
        this.setupPayloads();
        SpeexMediaManager.setupJMF();
    }

    @Override
    public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, JingleSession jingleSession) {
        return new AudioMediaSession(payloadType, remote, local, null, null);
    }

    private void setupPayloads() {
        this.payloads.add(new PayloadType.Audio(15, "speex"));
    }

    @Override
    public List<PayloadType> getPayloads() {
        return this.payloads;
    }

    public static void setupJMF() {
        File jmfProperties;
        String homeDir = System.getProperty("user.home");
        File jmfDir = new File(homeDir, ".jmf");
        String classpath = System.getProperty("java.class.path");
        classpath = classpath + System.getProperty("path.separator") + jmfDir.getAbsolutePath();
        System.setProperty("java.class.path", classpath);
        if (!jmfDir.exists()) {
            jmfDir.mkdir();
        }
        if (!(jmfProperties = new File(jmfDir, "jmf.properties")).exists()) {
            try {
                jmfProperties.createNewFile();
            }
            catch (IOException ex) {
                System.out.println("Failed to create jmf.properties");
                ex.printStackTrace();
            }
        }
        SpeexMediaManager.runLinuxPreInstall();
        if (jmfProperties.length() == 0L) {
            new JMFInit(null, false);
        }
    }

    private static void runLinuxPreInstall() {
    }
}

