/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.multi;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMediaManager
extends JingleMediaManager {
    private List<JingleMediaManager> managers = new ArrayList<JingleMediaManager>();
    private PayloadType preferredPayloadType = null;

    public void addMediaManager(JingleMediaManager manager) {
        this.managers.add(manager);
    }

    public void removeMediaManager(JingleMediaManager manager) {
        this.managers.remove(manager);
    }

    @Override
    public List<PayloadType> getPayloads() {
        ArrayList<PayloadType> list = new ArrayList<PayloadType>();
        if (this.preferredPayloadType != null) {
            list.add(this.preferredPayloadType);
        }
        for (JingleMediaManager manager : this.managers) {
            for (PayloadType payloadType : manager.getPayloads()) {
                if (list.contains(payloadType) || payloadType.equals(this.preferredPayloadType)) continue;
                list.add(payloadType);
            }
        }
        return list;
    }

    @Override
    public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, JingleSession jingleSession) {
        for (JingleMediaManager manager : this.managers) {
            if (!manager.getPayloads().contains(payloadType)) continue;
            return manager.createMediaSession(payloadType, remote, local, jingleSession);
        }
        return null;
    }

    @Override
    public PayloadType getPreferredPayloadType() {
        if (this.preferredPayloadType != null) {
            return this.preferredPayloadType;
        }
        return super.getPreferredPayloadType();
    }

    public void setPreferredPayloadType(PayloadType preferredPayloadType) {
        this.preferredPayloadType = preferredPayloadType;
    }
}

