/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class HttpServer {
    public HttpServer(int port) {
        try {
            ServerSocket server_socket = new ServerSocket(port);
            System.out.println("httpServer running on port " + server_socket.getLocalPort());
            while (true) {
                Socket socket = server_socket.accept();
                System.out.println("New connection accepted " + socket.getInetAddress() + ":" + socket.getPort());
                try {
                    HttpRequestHandler request = new HttpRequestHandler(socket);
                    Thread thread = new Thread(request);
                    thread.start();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
        catch (IOException e) {
            System.out.println(e);
            return;
        }
    }

    public static void main(String[] args) {
        HttpServer httpServer = new HttpServer(Integer.parseInt(args[0]));
    }

    class HttpRequestHandler
    implements Runnable {
        static final String CRLF = "\r\n";
        Socket socket;
        InputStream input;
        OutputStream output;
        BufferedReader br;

        public HttpRequestHandler(Socket socket) throws Exception {
            this.socket = socket;
            this.input = socket.getInputStream();
            this.output = socket.getOutputStream();
            this.br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        public void run() {
            try {
                this.processRequest();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void processRequest() throws Exception {
            while (true) {
                String headerLine = this.br.readLine();
                System.out.println(headerLine);
                if (headerLine.equals(CRLF) || headerLine.equals("")) break;
                StringTokenizer s = new StringTokenizer(headerLine);
                String temp = s.nextToken();
                if (!temp.equals("GET")) continue;
                String serverLine = "Server: Simple httpServer";
                String contentTypeLine = "text";
                String entityBody = "";
                String statusLine = "HTTP/1.0 200 OK\r\n";
                String contentLengthLine = "Content-Length: " + new Integer(entityBody.length()).toString() + CRLF;
                contentTypeLine = "text/html";
                this.output.write(statusLine.getBytes());
                this.output.write(serverLine.getBytes());
                this.output.write(contentTypeLine.getBytes());
                this.output.write(contentLengthLine.getBytes());
                this.output.write(CRLF.getBytes());
                this.output.write(entityBody.getBytes());
            }
            try {
                this.output.close();
                this.br.close();
                this.socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

