/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STUN
extends IQ {
    private List<StunServerAddress> servers = new ArrayList<StunServerAddress>();
    private String publicIp = null;
    public static final String NAME = "stun";
    public static final String ELEMENT_NAME = "query";
    public static final String NAMESPACE = "google:jingleinfo";

    public List<StunServerAddress> getServers() {
        return this.servers;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    private void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getChildElementXML() {
        StringBuilder str = new StringBuilder();
        str.append("<query xmlns='google:jingleinfo'/>");
        return str.toString();
    }

    public static STUN getSTUNServer(XMPPConnection xmppConnection) {
        if (!xmppConnection.isConnected()) {
            return null;
        }
        STUN stunPacket = new STUN();
        stunPacket.setTo("stun." + xmppConnection.getServiceName());
        PacketCollector collector = xmppConnection.createPacketCollector((PacketFilter)new PacketIDFilter(stunPacket.getPacketID()));
        xmppConnection.sendPacket((Packet)stunPacket);
        STUN response = (STUN)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        return response;
    }

    public static boolean serviceAvailable(XMPPConnection xmppConnection) {
        if (!xmppConnection.isConnected()) {
            return false;
        }
        System.out.println("Service listing");
        ServiceDiscoveryManager disco = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)xmppConnection);
        try {
            DiscoverItems items = disco.discoverItems(xmppConnection.getServiceName());
            Iterator iter = items.getItems();
            while (iter.hasNext()) {
                DiscoverItems.Item item = (DiscoverItems.Item)iter.next();
                DiscoverInfo info = disco.discoverInfo(item.getEntityID());
                Iterator iter2 = info.getIdentities();
                while (iter2.hasNext()) {
                    DiscoverInfo.Identity identity = (DiscoverInfo.Identity)iter2.next();
                    if (!identity.getCategory().equals("proxy") || !identity.getType().equals(NAME) || !info.containsFeature(NAMESPACE)) continue;
                    return true;
                }
                System.out.println(item.getName() + "-" + info.getType());
            }
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
        return false;
    }

    static {
        ProviderManager.getInstance().addIQProvider(NAME, NAMESPACE, (Object)new Provider());
    }

    public static class StunServerAddress {
        private String server;
        private String port;

        public StunServerAddress(String server, String port) {
            this.server = server;
            this.port = port;
        }

        public String getServer() {
            return this.server;
        }

        public String getPort() {
            return this.port;
        }
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            boolean done = false;
            if (!parser.getNamespace().equals(STUN.NAMESPACE)) {
                throw new Exception("Not a STUN packet");
            }
            STUN iq = new STUN();
            while (!done) {
                int eventType = parser.next();
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (eventType == 2) {
                    String host;
                    if (elementName.equals("server")) {
                        host = null;
                        String port = null;
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            if (parser.getAttributeName(i).equals("host")) {
                                host = parser.getAttributeValue(i);
                                continue;
                            }
                            if (!parser.getAttributeName(i).equals("udp")) continue;
                            port = parser.getAttributeValue(i);
                        }
                        if (host == null || port == null) continue;
                        iq.servers.add(new StunServerAddress(host, port));
                        continue;
                    }
                    if (!elementName.equals("publicip")) continue;
                    host = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!parser.getAttributeName(i).equals("ip")) continue;
                        host = parser.getAttributeValue(i);
                    }
                    if (host == null || host.equals("")) continue;
                    iq.setPublicIp(host);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(STUN.ELEMENT_NAME)) continue;
                done = true;
            }
            return iq;
        }
    }
}

