/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.jingle.nat.TransportResolverListener;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportNegotiator
extends JingleNegotiator {
    public static final int CANDIDATES_ACCEPT_PERIOD = 4000;
    private final JingleSession session;
    private final TransportResolver resolver;
    private final List<TransportCandidate> offeredCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> remoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> validRemoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> acceptedRemoteCandidates = new ArrayList<TransportCandidate>();
    private TransportCandidate acceptedLocalCandidate;
    private Thread resultThread;
    private TransportResolverListener.Resolver resolverListener;
    private final Inviting inviting;
    private final Accepting accepting;
    private final Pending pending;
    private final Active active;

    public TransportNegotiator(JingleSession js, TransportResolver transResolver) {
        super(js.getConnection());
        this.session = js;
        this.resolver = transResolver;
        this.resultThread = null;
        this.inviting = new Inviting(this);
        this.accepting = new Accepting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
    }

    public abstract JingleTransport getJingleTransport(TransportCandidate var1);

    public abstract boolean acceptableTransportCandidate(TransportCandidate var1, List<TransportCandidate> var2);

    public final TransportCandidate getBestLocalCandidate() {
        return this.resolver.getPreferredCandidate();
    }

    private void setAcceptedLocalCandidate(TransportCandidate bestLocalCandidate) throws XMPPException {
        for (int i = 0; i < this.resolver.getCandidateCount(); ++i) {
            if (!this.resolver.getCandidate(i).getIp().equals(bestLocalCandidate.getIp()) || this.resolver.getCandidate(i).getPort() != bestLocalCandidate.getPort()) continue;
            this.acceptedLocalCandidate = this.resolver.getCandidate(i);
            return;
        }
        throw new XMPPException("Local transport candidate has not be offered.");
    }

    public TransportCandidate getAcceptedLocalCandidate() {
        return this.acceptedLocalCandidate;
    }

    @Override
    public void close() {
        super.close();
    }

    public List<TransportCandidate> getOfferedCandidates() {
        return this.offeredCandidates;
    }

    public abstract TransportCandidate getBestRemoteCandidate();

    private List getRemoteCandidates() {
        return this.remoteCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteCandidate(TransportCandidate rc) {
        if (rc != null && this.acceptableTransportCandidate(rc, this.offeredCandidates)) {
            List<TransportCandidate> list = this.remoteCandidates;
            synchronized (list) {
                this.remoteCandidates.add(rc);
            }
            this.checkRemoteCandidate(rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOfferedCandidate(TransportCandidate rc) {
        if (rc != null) {
            List<TransportCandidate> list = this.offeredCandidates;
            synchronized (list) {
                this.offeredCandidates.add(rc);
            }
        }
    }

    private void checkRemoteCandidate(final TransportCandidate offeredCandidate) {
        offeredCandidate.addListener(new TransportResolverListener.Checker(){

            public void candidateChecked(TransportCandidate cand, boolean validCandidate) {
                if (validCandidate && !(TransportNegotiator.this.getState() instanceof Active)) {
                    TransportNegotiator.this.addValidRemoteCandidate(offeredCandidate);
                }
            }

            public void candidateChecking(TransportCandidate cand) {
            }
        });
        offeredCandidate.check(this.resolver.getCandidatesList());
    }

    private boolean isEstablished() {
        return this.getBestRemoteCandidate() != null && this.getAcceptedLocalCandidate() != null;
    }

    public final boolean isFullyEstablished() {
        return this.isEstablished() && this.getState() == this.active;
    }

    private void delayedCheckBestCandidate(final JingleSession js, final Jingle jin) {
        if (this.resultThread == null && !this.getRemoteCandidates().isEmpty()) {
            this.resultThread = new Thread(new Runnable(){

                public void run() {
                    TransportCandidate bestRemote;
                    int totalTime = 7000;
                    int tries = (int)Math.ceil(totalTime / 1000);
                    for (int i = 0; i < tries - 1; ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        TransportCandidate bestRemote2 = TransportNegotiator.this.getBestRemoteCandidate();
                        JingleNegotiator.State state = TransportNegotiator.this.getState();
                        if (bestRemote2 == null || state != TransportNegotiator.this.pending && state != TransportNegotiator.this.active) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(bestRemote2)) {
                            Jingle jout = new Jingle(Jingle.Action.TRANSPORTACCEPT);
                            jout.addTransport(TransportNegotiator.this.getJingleTransport(bestRemote2));
                            js.sendFormattedJingle(jin, jout);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(bestRemote2);
                        }
                        if (!TransportNegotiator.this.isEstablished()) continue;
                        TransportNegotiator.this.setState(TransportNegotiator.this.active);
                        break;
                    }
                    if ((bestRemote = TransportNegotiator.this.getBestRemoteCandidate()) == null) {
                        boolean foundRemoteRelay = false;
                        for (TransportCandidate candidate : TransportNegotiator.this.remoteCandidates) {
                            ICECandidate iceCandidate;
                            if (!(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals("relay")) continue;
                            TransportNegotiator.this.addValidRemoteCandidate(iceCandidate);
                            foundRemoteRelay = true;
                        }
                        if (!foundRemoteRelay) {
                            boolean foundLocalRelay = false;
                            for (TransportCandidate candidate : TransportNegotiator.this.offeredCandidates) {
                                ICECandidate iceCandidate;
                                if (!(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals("relay")) continue;
                                foundLocalRelay = true;
                            }
                            if (foundLocalRelay) {
                                ICECandidate iceCandidate;
                                boolean foundRemotePublic = false;
                                for (TransportCandidate candidate : TransportNegotiator.this.remoteCandidates) {
                                    if (!(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals((Object)ICECandidate.Type.srflx)) continue;
                                    TransportNegotiator.this.addValidRemoteCandidate(iceCandidate);
                                    foundRemotePublic = true;
                                }
                                if (!foundRemotePublic) {
                                    for (TransportCandidate candidate : TransportNegotiator.this.remoteCandidates) {
                                        if (!(candidate instanceof ICECandidate)) continue;
                                        iceCandidate = (ICECandidate)candidate;
                                        TransportNegotiator.this.addValidRemoteCandidate(iceCandidate);
                                    }
                                }
                            }
                        }
                    }
                    for (int i = 0; i < 6; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        bestRemote = TransportNegotiator.this.getBestRemoteCandidate();
                        JingleNegotiator.State state = TransportNegotiator.this.getState();
                        if (bestRemote == null || state != TransportNegotiator.this.pending && state != TransportNegotiator.this.active) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(bestRemote)) {
                            Jingle jout = new Jingle(Jingle.Action.TRANSPORTACCEPT);
                            jout.addTransport(TransportNegotiator.this.getJingleTransport(bestRemote));
                            js.sendFormattedJingle(jin, jout);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(bestRemote);
                        }
                        if (!TransportNegotiator.this.isEstablished()) continue;
                        TransportNegotiator.this.setState(TransportNegotiator.this.active);
                        break;
                    }
                    if (TransportNegotiator.this.getState() == null || !TransportNegotiator.this.getState().equals(TransportNegotiator.this.active)) {
                        try {
                            TransportNegotiator.this.session.terminate("Unable to negotiate session. This may be caused by firewall configuration problems.");
                        }
                        catch (XMPPException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, "Waiting for all the transport candidates checks...");
            this.resultThread.setName("Transport Resolver Result");
            this.resultThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidRemoteCandidate(TransportCandidate remoteCandidate) {
        if (remoteCandidate != null) {
            List<TransportCandidate> list = this.validRemoteCandidates;
            synchronized (list) {
                System.out.println("ADDED Valid Cand: " + remoteCandidate.getIp() + ":" + remoteCandidate.getPort());
                this.validRemoteCandidates.add(remoteCandidate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayList getValidRemoteCandidatesList() {
        List<TransportCandidate> list = this.validRemoteCandidates;
        synchronized (list) {
            return new ArrayList<TransportCandidate>(this.validRemoteCandidates);
        }
    }

    public final Iterator getValidRemoteCandidates() {
        return Collections.unmodifiableList(this.getRemoteCandidates()).iterator();
    }

    private void addRemoteCandidates(List rc) {
        if (rc != null && rc.size() > 0) {
            for (Object aRc : rc) {
                this.addRemoteCandidate((TransportCandidate)aRc);
            }
        }
    }

    private static ArrayList obtainCandidatesList(Jingle jin) {
        ArrayList<TransportCandidate> result = new ArrayList<TransportCandidate>();
        if (jin != null) {
            Iterator iTrans = jin.getTransports();
            while (iTrans.hasNext()) {
                JingleTransport trans = (JingleTransport)iTrans.next();
                Iterator iCand = trans.getCandidates();
                while (iCand.hasNext()) {
                    JingleTransport.JingleTransportCandidate cand = (JingleTransport.JingleTransportCandidate)iCand.next();
                    TransportCandidate transCand = cand.getMediaTransport();
                    result.add(transCand);
                }
            }
        }
        return result;
    }

    private boolean isOfferStarted() {
        return this.resolver.isResolving() || this.resolver.isResolved();
    }

    private synchronized void sendTransportCandidateOffer(TransportCandidate cand) {
        if (!cand.isNull()) {
            this.addOfferedCandidate(cand);
            this.session.sendFormattedJingle(new Jingle(this.getJingleTransport(cand)));
        }
    }

    private void sendTransportCandidatesOffer() throws XMPPException {
        List<TransportCandidate> notOffered = this.resolver.getCandidatesList();
        notOffered.removeAll(this.offeredCandidates);
        for (TransportCandidate aNotOffered : notOffered) {
            this.sendTransportCandidateOffer(aNotOffered);
        }
        if (this.resolverListener == null) {
            this.resolverListener = new TransportResolverListener.Resolver(){

                public void candidateAdded(TransportCandidate cand) {
                    TransportNegotiator.this.sendTransportCandidateOffer(cand);
                }

                public void end() {
                }

                public void init() {
                }
            };
            this.resolver.addListener(this.resolverListener);
        }
        if (!this.resolver.isResolving() && !this.resolver.isResolved()) {
            System.out.println("RESOLVER CALLED");
            this.resolver.resolve(this.session);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final IQ dispatchIncomingPacket(IQ iq, String id) throws XMPPException {
        Jingle jout = null;
        if (this.invalidState()) {
            if (iq == null) {
                this.setState(this.inviting);
                jout = this.getState().eventInvite();
            } else {
                if (!(iq instanceof Jingle)) throw new IllegalStateException("Invitation IQ received is not a Jingle packet in Transport negotiator.");
                this.setState(this.accepting);
                jout = this.getState().eventInitiate((Jingle)iq);
            }
        } else {
            Jingle jin;
            Jingle.Action action;
            if (iq == null) {
                return null;
            }
            if (iq.getType().equals(IQ.Type.ERROR)) {
                this.getState().eventError(iq);
            } else if (iq.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iq.getPacketID())) {
                    jout = this.getState().eventAck(iq);
                    this.removeExpectedId(iq.getPacketID());
                }
            } else if (iq instanceof Jingle && (action = (jin = (Jingle)iq).getAction()) != null) {
                if (action.equals((Object)Jingle.Action.TRANSPORTACCEPT)) {
                    jout = this.getState().eventAccept(jin);
                } else if (action.equals((Object)Jingle.Action.TRANSPORTDECLINE)) {
                    jout = this.getState().eventDecline(jin);
                } else if (action.equals((Object)Jingle.Action.TRANSPORTINFO)) {
                    jout = this.getState().eventInfo(jin);
                } else if (action.equals((Object)Jingle.Action.TRANSPORTMODIFY)) {
                    jout = this.getState().eventModify(jin);
                }
            }
        }
        if (id != null) {
            this.addExpectedId(id);
            return jout;
        } else {
            if (jout == null) return jout;
            this.addExpectedId(jout.getPacketID());
        }
        return jout;
    }

    private void triggerTransportEstablished(TransportCandidate local, TransportCandidate remote) {
        ArrayList listeners = this.getListenersList();
        for (Object listener : listeners) {
            JingleListener li = (JingleListener)listener;
            if (!(li instanceof JingleTransportListener)) continue;
            JingleTransportListener mli = (JingleTransportListener)li;
            System.out.println("triggerTransportEstablished " + local.getLocalIp() + ":" + local.getPort() + "|" + remote.getIp() + ":" + remote.getPort());
            mli.transportEstablished(local, remote);
        }
    }

    private void triggerTransportClosed(TransportCandidate cand) {
        ArrayList listeners = this.getListenersList();
        for (Object listener : listeners) {
            JingleListener li = (JingleListener)listener;
            if (!(li instanceof JingleTransportListener)) continue;
            JingleTransportListener mli = (JingleTransportListener)li;
            mli.transportClosed(cand);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Ice
    extends TransportNegotiator {
        public Ice(JingleSession js, TransportResolver res) {
            super(js, res);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate candidate) {
            JingleTransport.Ice jt = new JingleTransport.Ice();
            jt.addCandidate(new JingleTransport.Ice.Candidate(candidate));
            return jt;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ICECandidate result = null;
            ArrayList cands = this.getValidRemoteCandidatesList();
            if (!cands.isEmpty()) {
                int highest = -1;
                ICECandidate chose = null;
                for (ICECandidate transportCandidate : cands) {
                    if (transportCandidate.getPreference() <= highest) continue;
                    chose = transportCandidate;
                    highest = transportCandidate.getPreference();
                }
                result = chose;
            }
            if (result != null && result.getType().equals("relay")) {
                System.out.println("Relay Type");
            }
            return result;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate tc, List<TransportCandidate> localCandidates) {
            return tc instanceof ICECandidate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RawUdp
    extends TransportNegotiator {
        public RawUdp(JingleSession js, TransportResolver res) {
            super(js, res);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate bestRemote) {
            JingleTransport.RawUdp jt = new JingleTransport.RawUdp();
            jt.addCandidate(new JingleTransport.RawUdp.Candidate(bestRemote));
            return jt;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ArrayList cands = this.getValidRemoteCandidatesList();
            if (!cands.isEmpty()) {
                System.out.println("RAW CAND");
                return (TransportCandidate)cands.get(0);
            }
            System.out.println("No Remote Candidate");
            return null;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate tc, List<TransportCandidate> localCandidates) {
            return tc instanceof TransportCandidate.Fixed;
        }
    }

    public final class Active
    extends JingleNegotiator.State {
        public Active(TransportNegotiator neg) {
            super(neg);
        }

        public void eventEnter() {
            System.out.println("Transport stabilished");
            TransportNegotiator.this.triggerTransportEstablished(TransportNegotiator.this.getAcceptedLocalCandidate(), TransportNegotiator.this.getBestRemoteCandidate());
            super.eventEnter();
        }

        public void eventExit() {
            TransportNegotiator.this.triggerTransportClosed(null);
            super.eventExit();
        }
    }

    public final class Pending
    extends JingleNegotiator.State {
        public Pending(TransportNegotiator neg) {
            super(neg);
        }

        public Jingle eventAccept(Jingle jin) throws XMPPException {
            Jingle response = null;
            ArrayList accepted = TransportNegotiator.obtainCandidatesList(jin);
            if (!accepted.isEmpty()) {
                for (TransportCandidate cand : accepted) {
                    System.out.println("Cand: " + cand.getIp());
                }
                TransportCandidate cand = (TransportCandidate)accepted.get(0);
                TransportNegotiator.this.setAcceptedLocalCandidate(cand);
                if (TransportNegotiator.this.isEstablished()) {
                    System.out.println("SET ACTIVE");
                    TransportNegotiator.this.setState(TransportNegotiator.this.active);
                }
            }
            return response;
        }

        public Jingle eventInfo(Jingle jin) throws XMPPException {
            TransportNegotiator.this.sendTransportCandidatesOffer();
            TransportNegotiator.this.addRemoteCandidates(TransportNegotiator.obtainCandidatesList(jin));
            TransportNegotiator.this.delayedCheckBestCandidate(TransportNegotiator.this.session, jin);
            return null;
        }

        public Jingle eventDecline(Jingle inJingle) throws JingleNegotiator.JingleException {
            throw new JingleNegotiator.JingleException("No common payload found.");
        }
    }

    public final class Accepting
    extends JingleNegotiator.State {
        public Accepting(TransportNegotiator neg) {
            super(neg);
        }

        public Jingle eventInitiate(Jingle jin) throws XMPPException {
            TransportNegotiator.this.sendTransportCandidatesOffer();
            TransportNegotiator.this.delayedCheckBestCandidate(TransportNegotiator.this.session, jin);
            TransportNegotiator.this.setState(TransportNegotiator.this.pending);
            return super.eventInitiate(jin);
        }
    }

    public final class Inviting
    extends JingleNegotiator.State {
        public Inviting(TransportNegotiator neg) {
            super(neg);
        }

        public Jingle eventInvite() {
            return new Jingle(TransportNegotiator.this.getJingleTransport(null));
        }

        public Jingle eventInfo(Jingle jin) throws XMPPException {
            TransportNegotiator.this.addRemoteCandidates(TransportNegotiator.obtainCandidatesList(jin));
            TransportNegotiator.this.delayedCheckBestCandidate(TransportNegotiator.this.session, jin);
            return null;
        }

        public Jingle eventAck(IQ iq) throws XMPPException {
            TransportNegotiator.this.sendTransportCandidatesOffer();
            TransportNegotiator.this.setState(TransportNegotiator.this.pending);
            return super.eventAck(iq);
        }
    }
}

