/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.packet.JingleContentDescription;
import org.jivesoftware.smackx.packet.JingleContentInfo;
import org.jivesoftware.smackx.packet.JingleTransport;

public class Jingle
extends IQ {
    public static final String NAMESPACE = "http://jabber.org/protocol/jingle";
    public static final String NODENAME = "jingle";
    private String sid;
    private Action action;
    private String initiator;
    private String responder;
    private final List descriptions = new ArrayList();
    private final List transports = new ArrayList();
    private JingleContentInfo contentInfo;

    public Jingle(List descs, List trans, JingleContentInfo mi, String sid) {
        if (descs != null) {
            this.descriptions.addAll(descs);
        }
        if (trans != null) {
            this.transports.addAll(trans);
        }
        this.setContentInfo(mi);
        this.setSid(sid);
        this.initiator = null;
        this.responder = null;
        this.action = null;
    }

    public Jingle(JingleContentDescription descr) {
        this.addDescription(descr);
        this.initiator = null;
        this.responder = null;
        this.action = Action.DESCRIPTIONINFO;
        this.setType(IQ.Type.SET);
    }

    public Jingle(JingleTransport trans) {
        this.addTransport(trans);
        this.initiator = null;
        this.responder = null;
        this.action = Action.TRANSPORTINFO;
        this.setType(IQ.Type.SET);
    }

    public Jingle(JingleContentInfo info) {
        this.setContentInfo(info);
        this.initiator = null;
        this.responder = null;
        this.action = Action.DESCRIPTIONINFO;
        this.setType(IQ.Type.SET);
    }

    public Jingle(Action action) {
        this(null, null, null, null);
        this.action = action;
        this.setType(IQ.Type.SET);
    }

    public Jingle(String sid) {
        this(null, null, null, sid);
    }

    public Jingle() {
    }

    public final void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public static String getElementName() {
        return NODENAME;
    }

    public static String getNamespace() {
        return NAMESPACE;
    }

    public JingleContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(JingleContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getDescriptions() {
        List list = this.descriptions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.descriptions)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDescriptionsList() {
        List list = this.descriptions;
        synchronized (list) {
            return new ArrayList(this.descriptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescription(JingleContentDescription desc) {
        if (desc != null) {
            List list = this.descriptions;
            synchronized (list) {
                this.descriptions.add(desc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptions(List descsList) {
        if (descsList != null) {
            List list = this.descriptions;
            synchronized (list) {
                this.descriptions.addAll(descsList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getTransports() {
        List list = this.transports;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList(this.transports)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTransportsList() {
        List list = this.transports;
        synchronized (list) {
            return new ArrayList(this.transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransport(JingleTransport trans) {
        if (trans != null) {
            List list = this.transports;
            synchronized (list) {
                this.transports.add(trans);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransports(List transList) {
        if (transList != null) {
            List list = this.transports;
            synchronized (list) {
                this.transports.addAll(transList);
            }
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getResponder() {
        return this.responder;
    }

    public void setResponder(String resp) {
        this.responder = resp;
    }

    public static int getSessionHash(String sid, String initiator) {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (initiator == null ? 0 : initiator.hashCode());
        result = 31 * result + (sid == null ? 0 : sid.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChildElementXML() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(Jingle.getElementName());
        buf.append(" xmlns=\"").append(Jingle.getNamespace()).append("\"");
        if (this.getInitiator() != null) {
            buf.append(" initiator=\"").append(this.getInitiator()).append("\"");
        }
        if (this.getResponder() != null) {
            buf.append(" responder=\"").append(this.getResponder()).append("\"");
        }
        if (this.getAction() != null) {
            buf.append(" action=\"").append((Object)this.getAction()).append("\"");
        }
        if (this.getSid() != null) {
            buf.append(" sid=\"").append(this.getSid()).append("\"");
        }
        buf.append(">");
        buf.append("<content name='Audio-Content'>");
        List list = this.descriptions;
        synchronized (list) {
            for (i = 0; i < this.descriptions.size(); ++i) {
                JingleContentDescription desc = (JingleContentDescription)this.descriptions.get(i);
                buf.append(desc.toXML());
            }
        }
        list = this.transports;
        synchronized (list) {
            for (i = 0; i < this.transports.size(); ++i) {
                JingleTransport trans = (JingleTransport)this.transports.get(i);
                buf.append(trans.toXML());
            }
        }
        buf.append("</content>");
        if (this.contentInfo != null) {
            buf.append(this.contentInfo.toXML());
        }
        buf.append("</").append(Jingle.getElementName()).append(">");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        CONTENTACCEPT,
        CONTENTADD,
        CONTENTDECLINE,
        CONTENTMODIFY,
        CONTENTREMOVE,
        DESCRIPTIONADD,
        DESCRIPTIONDECLINE,
        DESCRIPTIONINFO,
        DESCRIPTIONMODIFY,
        SESSIONACCEPT,
        SESSIONINFO,
        SESSIONINITIATE,
        SESSIONREDIRECT,
        SESSIONTERMINATE,
        TRANSPORTACCEPT,
        TRANSPORTDECLINE,
        TRANSPORTINFO,
        TRANSPORTMODIFY;

        private static String[] names;

        public String toString() {
            return names[this.ordinal()];
        }

        public static Action getAction(String str) {
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(str)) continue;
                return Action.values()[i];
            }
            return null;
        }

        static {
            names = new String[]{"content-accept", "content-add", "content-decline", "content-modify", "content-remove", "description-accept", "description-decline", "description-info", "description-modify", "session-accept", "session-info", "session-initiate", "session-redirect", "session-terminate", "transport-accept", "transport-decline", "transport-info", "transport-modify"};
        }
    }
}

