/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package javax.faces.view;

/**
 * <p class="changed_added_2_0">Represent an attached object that is a
 * <code>BehaviorHolder</code> in a VDL page.</p>
 */
public interface BehaviorHolderAttachedObjectHandler extends AttachedObjectHandler {

    /**
     * <p class="changed_added_2_0">Return the client event name to
     * which this behavior applies.</p>
     *
     * @since 2.0

     * @return the client event name for this behavior
     */
    public String getEventName();

}
