/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package jakarta.resource.spi;

import java.lang.annotation.Target;
import static java.lang.annotation.ElementType.*;
import java.lang.annotation.Retention;
import java.lang.annotation.Documented;
import static java.lang.annotation.RetentionPolicy.*;

/**
 * Designates a JavaBean as an administered object.Administered objects are
 * specific to a messaging style or message provider.
 * 
 * @since 1.6
 */

@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface AdministeredObject {

	/**
	 * Specifies the Java type of the interface implemented by the administered
	 * object.
         * @return the Java type of the interface implemented by the administered
	 * object.
	 */
	Class[] adminObjectInterfaces() default {};
}
