/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;

public class FLOWCONTROL
extends Protocol {
    Vector queuedMsgs = new Vector();
    int sentMsgs = 0;
    static int MAXSENTMSGS = 1;
    Address myAddr;

    public String getName() {
        return "FLOWCONTROL";
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.myAddr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (Trace.trace) {
                    Trace.debug("FLOWCONTROL.up()", "Message received");
                }
                if (!msg.getSrc().equals(this.myAddr)) break;
                if (this.queuedMsgs.size() > 0) {
                    if (Trace.trace) {
                        Trace.debug("FLOWCONTROL.up()", "Message from me received - Queue size was " + this.queuedMsgs.size());
                    }
                    this.passDown((Event)this.queuedMsgs.remove(0));
                    break;
                }
                if (Trace.trace) {
                    Trace.debug("FLOWCONTROL.up()", "Message from me received - No messages in queue");
                }
                --this.sentMsgs;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        Message msg;
        if (evt.getType() == 1 && ((msg = (Message)evt.getArg()).getDest() == null || msg.getDest().equals(this.myAddr))) {
            if (this.sentMsgs < MAXSENTMSGS) {
                ++this.sentMsgs;
                if (Trace.trace) {
                    Trace.debug("FLOWCONTROL.down()", "Message " + this.sentMsgs + " sent");
                }
            } else {
                this.queuedMsgs.add(evt);
                return;
            }
        }
        this.passDown(evt);
    }
}

