/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.log.Trace;
import org.jgroups.protocols.Digest;
import org.jgroups.protocols.FlushRsp;
import org.jgroups.stack.RpcProtocol;
import org.jgroups.util.List;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class FLUSH
extends RpcProtocol {
    Vector mbrs = new Vector();
    boolean is_server = false;
    Object block_mutex = new Object();
    long block_timeout = 5000L;
    Address local_addr = null;
    boolean blocked = false;
    Object digest_mutex = new Object();
    long digest_timeout = 2000L;
    Object highest_delivered_mutex = new Object();
    long[] highest_delivered_msgs;
    Digest digest = null;
    Object get_msgs_mutex = new Object();
    long get_msgs_timeout = 4000L;
    List get_msgs = null;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class array$J;

    public String getName() {
        return "FLUSH";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(27));
        return retval;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(35));
        retval.addElement(new Integer(31));
        retval.addElement(new Integer(37));
        return retval;
    }

    public void start() throws Exception {
        super.start();
        if (this._corr == null) {
            throw new Exception("FLUSH.start(): cannot set deadlock detection in corr, as it is null !");
        }
        this._corr.setDeadlockDetection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlushRsp flush(Vector dests) {
        int i;
        FlushRsp retval = new FlushRsp();
        List unstable_msgs = new List();
        boolean get_lower_msgs = false;
        this.highest_delivered_msgs = new long[this.members.size()];
        long[] min = new long[this.members.size()];
        long[] max = new long[this.members.size()];
        this.getHighestDeliveredSeqnos();
        for (int i2 = 0; i2 < this.highest_delivered_msgs.length; ++i2) {
            min[i2] = max[i2] = this.highest_delivered_msgs[i2];
        }
        if (Trace.trace) {
            Trace.info("FLUSH.flush()", "calling HandleFlush(" + dests + ")");
        }
        this.passDown(new Event(26));
        MethodCall call = new MethodCall("handleFlush", new Object[]{dests, this.highest_delivered_msgs.clone()}, new String[]{(class$java$util$Vector == null ? (class$java$util$Vector = FLUSH.class$("java.util.Vector")) : class$java$util$Vector).getName(), (array$J == null ? (array$J = FLUSH.class$("[J")) : array$J).getName()});
        RspList rsp_list = this.callRemoteMethods(dests, call, 2, 0L);
        if (Trace.trace) {
            Trace.info("FLUSH.flush()", "flush done");
        }
        for (i = 0; i < rsp_list.size(); ++i) {
            Digest digest;
            Rsp rsp = (Rsp)rsp_list.elementAt(i);
            if (!rsp.wasReceived() || (digest = (Digest)rsp.getValue()) == null) continue;
            for (int j = 0; j < digest.highest_seqnos.length && j < min.length; ++j) {
                min[j] = Math.min(min[j], digest.highest_seqnos[j]);
                max[j] = Math.max(max[j], digest.highest_seqnos[j]);
            }
            if (digest.msgs.size() <= 0) continue;
            Enumeration e = digest.msgs.elements();
            while (e.hasMoreElements()) {
                unstable_msgs.add(e.nextElement());
            }
        }
        long[][] lower = new long[min.length][];
        for (i = 0; i < min.length; ++i) {
            if (min[i] >= this.highest_delivered_msgs[i]) continue;
            lower[i] = new long[2];
            lower[i][0] = min[i];
            lower[i][1] = this.highest_delivered_msgs[i];
            get_lower_msgs = true;
        }
        if (get_lower_msgs) {
            this.get_msgs = null;
            Object i3 = this.get_msgs_mutex;
            synchronized (i3) {
                this.passDown(new Event(37, lower));
                try {
                    this.get_msgs_mutex.wait(this.get_msgs_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.get_msgs != null) {
                Enumeration e = this.get_msgs.elements();
                while (e.hasMoreElements()) {
                    unstable_msgs.add(e.nextElement());
                }
            }
        }
        retval.unstable_msgs = unstable_msgs.getContents();
        if (rsp_list.numSuspectedMembers() > 0) {
            retval.result = false;
            retval.failed_mbrs = rsp_list.getSuspectedMembers();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Digest handleFlush(Vector flush_dests, long[] highest_seqnos) {
        this.digest = null;
        if (Trace.trace) {
            Trace.info("FLUSH.handleFlush()", "flush_dests=" + flush_dests + " , highest_seqnos=" + Util.array2String(highest_seqnos));
        }
        if (!this.is_server) {
            return this.digest;
        }
        if (flush_dests == null) {
            if (Trace.trace) {
                Trace.warn("FLUSH.handleFlush()", "flush dest is null, ignoring flush !");
            }
            return this.digest;
        }
        if (flush_dests.size() == 0) {
            if (Trace.trace) {
                Trace.warn("FLUSH.handleFlush()", "flush dest is empty, ignoring flush !");
            }
            return this.digest;
        }
        if (!flush_dests.contains(this.local_addr)) {
            if (Trace.trace) {
                Trace.warn("FLUSH.handleFlush()", "am not in the flush dests, ignoring flush");
            }
            return this.digest;
        }
        if (!this.blocked) {
            this.blocked = true;
            Object object = this.block_mutex;
            synchronized (object) {
                this.passUp(new Event(10));
                try {
                    this.block_mutex.wait(this.block_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.getMessageDigest(highest_seqnos);
        if (Trace.trace) {
            Trace.info("FLUSH.handleFlush()", "returning digest : " + this.digest);
        }
        return this.digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getHighestDeliveredSeqnos() {
        Object object = this.highest_delivered_mutex;
        synchronized (object) {
            this.passDown(new Event(35));
            try {
                this.highest_delivered_mutex.wait(4000L);
            }
            catch (Exception e) {
                Trace.debug("FLUSH.getHighestDeliveredSeqnos()", "exception is " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMessageDigest(long[] highest_seqnos) {
        Object object = this.digest_mutex;
        synchronized (object) {
            this.passDown(new Event(31, highest_seqnos));
            try {
                this.digest_mutex.wait(this.digest_timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 32: {
                Object object = this.digest_mutex;
                synchronized (object) {
                    this.digest = (Digest)evt.getArg();
                    this.digest_mutex.notify();
                }
                return false;
            }
            case 36: {
                long[] tmp = (long[])evt.getArg();
                if (tmp != null) {
                    for (int i = 0; i < tmp.length; ++i) {
                        this.highest_delivered_msgs[i] = tmp[i];
                    }
                }
                Object object = this.highest_delivered_mutex;
                synchronized (object) {
                    this.highest_delivered_mutex.notify();
                }
                return false;
            }
            case 38: {
                Object object = this.get_msgs_mutex;
                synchronized (object) {
                    this.get_msgs = (List)evt.getArg();
                    this.get_msgs_mutex.notify();
                    break;
                }
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 27: {
                Vector dests = (Vector)evt.getArg();
                if (dests == null) {
                    dests = new Vector();
                }
                FlushRsp rsp = this.flush(dests);
                this.passUp(new Event(28, rsp));
                return false;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 6: {
                this.blocked = false;
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp == null) break;
                this.mbrs.removeAllElements();
                for (int i = 0; i < tmp.size(); ++i) {
                    this.mbrs.addElement(tmp.elementAt(i));
                }
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDownEvent(Event evt) {
        if (evt.getType() == 11) {
            Object object = this.down_queue;
            synchronized (object) {
                try {
                    while (this.down_queue.size() > 0) {
                        Event event = (Event)this.down_queue.remove(10L);
                        this.down(event);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            object = this.block_mutex;
            synchronized (object) {
                this.block_mutex.notify();
            }
            return;
        }
        super.receiveDownEvent(evt);
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("block_timeout");
        if (str != null) {
            this.block_timeout = new Long(str);
            props.remove("block_timeout");
        }
        if ((str = props.getProperty("digest_timeout")) != null) {
            this.digest_timeout = new Long(str);
            props.remove("digest_timeout");
        }
        if (props.size() > 0) {
            System.err.println("EXAMPLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

