/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Header;

public class UdpHeader
extends Header {
    public String group_addr = null;
    transient byte[] data = null;

    public UdpHeader() {
    }

    public UdpHeader(String n) {
        this.group_addr = n;
        this.data = this.group_addr.getBytes();
    }

    public String toString() {
        return "[UDP:group_addr=" + this.group_addr + "]";
    }

    public long size() {
        return 100L;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.data != null) {
            out.writeInt(this.data.length);
            out.write(this.data, 0, this.data.length);
        } else {
            out.writeInt(0);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        if (len > 0) {
            this.data = new byte[len];
            in.readFully(this.data, 0, len);
            this.group_addr = new String(this.data);
        }
    }
}

