/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.Range;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand {
    long[] retransmit_timeout = new long[]{600L, 1200L, 2400L, 4800L};
    boolean is_server = false;
    Address local_addr = null;
    Vector members = new Vector();
    long seqno = 0L;
    long deleted_up_to = 0L;
    long max_xmit_size = 8192L;
    int gc_lag = 20;
    boolean use_mcast_xmit = false;
    Hashtable received_msgs = new Hashtable();
    Hashtable sent_msgs = new Hashtable();
    boolean leaving = false;
    TimeScheduler timer = null;
    final String name = "NAKACK";

    public String getName() {
        return "NAKACK";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(53));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        return retval;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("NAKACK.up(): timer is null");
        }
    }

    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeAll();
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.send(msg);
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigest();
                this.passUp(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passUp(new Event(58, digest));
                return;
            }
            case 42: {
                Digest digest = this.getDigest();
                this.passUp(new Event(43, digest));
                return;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return;
            }
            case 56: {
                this.passDown(evt);
                if (Trace.trace) {
                    Trace.info("NAKACK.down()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 15: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                break;
            }
            case 6: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                this.is_server = true;
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 4: {
                this.leaving = true;
                this.removeAll();
                this.seqno = 0L;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(58, digest));
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 56: {
                this.passUp(evt);
                if (Trace.trace) {
                    Trace.info("NAKACK.up()", "received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader("NAKACK");
                if (obj == null || !(obj instanceof NakAckHeader)) break;
                if (!this.is_server) {
                    if (Trace.trace) {
                        Trace.debug("NAKACK.up()", "message was discarded (not yet server)");
                    }
                    return;
                }
                NakAckHeader hdr = (NakAckHeader)obj;
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (Trace.trace) {
                                Trace.error("NAKACK.up()", "XMIT_REQ: range of xmit msg == null; discarding request from " + msg.getSrc());
                            }
                            return;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high);
                        return;
                    }
                    case 3: {
                        this.handleXmitRsp(msg);
                        return;
                    }
                }
                Trace.error("NAKACK.up()", "NakAck header type " + hdr.type + " not known !");
                return;
            }
        }
        this.passUp(evt);
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = new Integer(str);
            if (this.gc_lag < 1) {
                System.err.println("NAKACK.setProperties(): gc_lag has to be at least 1 (set to 10)");
                this.gc_lag = 10;
            }
            props.remove("gc_lag");
        }
        if ((str = props.getProperty("max_xmit_size")) != null) {
            this.max_xmit_size = Long.parseLong(str);
            props.remove("max_xmit_size");
        }
        if ((str = props.getProperty("use_mcast_xmit")) != null) {
            this.use_mcast_xmit = new Boolean(str);
            props.remove("use_mcast_xmit");
        }
        if (props.size() > 0) {
            System.err.println("NAKACK.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    long getNextSeqno() {
        return this.seqno++;
    }

    void send(Message msg) {
        long msg_id = this.getNextSeqno();
        msg.putHeader("NAKACK", new NakAckHeader(1, msg_id));
        this.sent_msgs.put(new Long(msg_id), msg);
        this.passDown(new Event(1, msg));
    }

    void handleMessage(Message msg, NakAckHeader hdr) {
        Message msg_to_deliver;
        NakReceiverWindow win = null;
        if (msg == null || hdr == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleMessage()", "msg or header is null");
            }
            return;
        }
        Address sender = msg.getSrc();
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.handleMessage()", "sender of message is null");
            }
            return;
        }
        win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (Trace.trace) {
                Trace.warn("NAKACK.handleMessage()", "[" + this.local_addr + "] discarded message from non-member " + sender);
            }
            return;
        }
        win.add(hdr.seqno, msg);
        while ((msg_to_deliver = win.remove()) != null) {
            this.passUp(new Event(1, msg_to_deliver));
        }
    }

    void handleXmitReq(Address dest, long first_seqno, long last_seqno) {
        long size = 0L;
        long marker = first_seqno;
        if (first_seqno > last_seqno) {
            Trace.error("NAKACK.handleXmitReq()", "first_seqno (" + first_seqno + ") > last_seqno (" + last_seqno + "): not able to retransmit");
            return;
        }
        LinkedList<Message> list = new LinkedList<Message>();
        for (long i = first_seqno; i <= last_seqno; ++i) {
            Message m = (Message)this.sent_msgs.get(new Long(i));
            if (m == null) {
                Trace.error("NAKACK.handleXmitReq()", "(requester=" + dest + ") message with " + "seqno=" + i + " not found in sent_msgs ! sent_msgs=" + this.printSentMsgs());
                continue;
            }
            if ((size += m.size()) >= this.max_xmit_size) {
                if (Trace.trace) {
                    Trace.debug("NAKACK.handleXmitReq()", "xmitting msgs [" + marker + "-" + (i - 1L) + "] to " + dest);
                }
                this.sendXmitRsp(dest, (LinkedList)list.clone(), marker, i - 1L);
                marker = i;
                list.clear();
                size = 0L;
            }
            Message tmp = m;
            tmp.setDest(dest);
            tmp.setSrc(this.local_addr);
            list.add(tmp);
        }
        if (list.size() > 0) {
            if (Trace.trace) {
                Trace.debug("NAKACK.handleXmitReq()", "xmitting msgs [" + marker + "-" + last_seqno + "] to " + dest);
            }
            this.sendXmitRsp(dest, (LinkedList)list.clone(), marker, last_seqno);
        }
    }

    void sendXmitRsp(Address dest, LinkedList xmit_list, long first_seqno, long last_seqno) {
        if (this.use_mcast_xmit) {
            dest = null;
        }
        Message msg = new Message(dest, null, xmit_list);
        msg.putHeader("NAKACK", new NakAckHeader(3, first_seqno, last_seqno));
        this.passDown(new Event(1, msg));
    }

    void handleXmitRsp(Message msg) {
        if (msg == null) {
            Trace.warn("NAKACK.handleXmitRsp()", "message is null");
            return;
        }
        try {
            LinkedList list = (LinkedList)msg.getObject();
            if (list != null) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    Message m = (Message)it.next();
                    this.up(new Event(1, m));
                }
            }
        }
        catch (Exception ex) {
            Trace.error("NAKACK.handleXmitRsp()", "message did not contain a list (LinkedList) of retransmitted messages: " + ex);
        }
    }

    void adjustReceivers() {
        NakReceiverWindow win;
        Address sender;
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            sender = (Address)e.nextElement();
            if (this.members.contains(sender)) continue;
            win = (NakReceiverWindow)this.received_msgs.get(sender);
            win.reset();
            if (Trace.trace) {
                Trace.info("NAKACK.adjustReceivers()", "removing " + sender + " from received_msgs (not member anymore)");
            }
            this.received_msgs.remove(sender);
        }
        for (int i = 0; i < this.members.size(); ++i) {
            sender = (Address)this.members.elementAt(i);
            if (this.received_msgs.containsKey(sender)) continue;
            win = new NakReceiverWindow(sender, this, 0L, this.timer);
            win.setRetransmitTimeouts(this.retransmit_timeout);
            this.received_msgs.put(sender, win);
        }
    }

    Digest getDigest() {
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, false);
            if (range == null) {
                if (!Trace.trace) continue;
                Trace.error("NAKACK.getDigest()", "range is null");
                continue;
            }
            digest.add(sender, range.low, range.high);
        }
        return digest;
    }

    Digest getDigestHighestDeliveredMsgs() {
        long high_seqno_seen = 0L;
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, true);
            if (range == null) {
                if (!Trace.trace) continue;
                Trace.error("NAKACK.getDigest()", "range is null");
                continue;
            }
            high_seqno_seen = this.getHighSeqnoSeen(sender);
            digest.add(sender, range.low, range.high, high_seqno_seen);
        }
        return digest;
    }

    void setDigest(Digest d) {
        this.clear();
        if (d == null || d.senders == null) {
            Trace.error("NAKACK.setDigest()", "digest or digest.senders is null");
            return;
        }
        for (int i = 0; i < d.size(); ++i) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                Trace.error("NAKACK.setDigest()", "sender at index " + i + " in digest is null");
                continue;
            }
            long initial_seqno = d.highSeqnoAt(i);
            NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
            win.setRetransmitTimeouts(this.retransmit_timeout);
            this.received_msgs.put(sender, win);
        }
    }

    void mergeDigest(Digest d) {
        if (d == null || d.senders == null) {
            Trace.error("NAKACK.mergeDigest()", "digest or digest.senders is null");
            return;
        }
        for (int i = 0; i < d.size(); ++i) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                Trace.error("NAKACK.mergeDigest()", "sender at index " + i + " in digest is null");
                continue;
            }
            long initial_seqno = d.highSeqnoAt(i);
            NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
            if (win == null) {
                win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                win.setRetransmitTimeouts(this.retransmit_timeout);
                this.received_msgs.put(sender, win);
                continue;
            }
            if (win.getHighestReceived() >= initial_seqno) continue;
            win.reset();
            this.received_msgs.remove(sender);
            win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
            win.setRetransmitTimeouts(this.retransmit_timeout);
            this.received_msgs.put(sender, win);
        }
    }

    Range getLowestAndHighestSeqno(Address sender, boolean stop_at_gaps) {
        Range r = null;
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.getLowestAndHighestSeqno()", "sender is null");
            }
            return r;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            Trace.error("NAKACK.getLowestAndHighestSeqno()", "sender " + sender + " not found in received_msgs");
            return r;
        }
        r = stop_at_gaps ? new Range(win.getLowestSeen(), win.getHighestSeen()) : new Range(win.getLowestSeen(), win.getHighestReceived() + 1L);
        return r;
    }

    long getHighSeqnoSeen(Address sender) {
        long ret = 0L;
        if (sender == null) {
            if (Trace.trace) {
                Trace.error("NAKACK.getHighSeqnoSeen()", "sender is null");
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
        if (win == null) {
            Trace.error("NAKACK.getHighSeqnoSeen()", "sender " + sender + " not found in received_msgs");
            return ret;
        }
        ret = win.getHighestReceived();
        return ret;
    }

    void stable(Digest d) {
        if (this.members == null || this.local_addr == null || d == null) {
            if (Trace.trace) {
                Trace.warn("NAKACK.stable()", "members, local_addr or digest are null !");
            }
            return;
        }
        if (Trace.trace) {
            Trace.info("NAKACK.stable()", "received digest " + d);
        }
        for (int i = 0; i < d.size(); ++i) {
            Address sender = d.senderAt(i);
            long seqno = d.highSeqnoAt(i);
            if (sender == null) continue;
            NakReceiverWindow recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = d.highSeqnoSeenAt(i);
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (Trace.trace) {
                        Trace.debug("NAKACK.stable()", "my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + "#" + stability_highest_rcvd);
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                }
            }
            if ((seqno -= (long)this.gc_lag) < 0L) continue;
            if (Trace.trace) {
                Trace.info("NAKACK.stable()", "deleting stable msgs < " + sender + "#" + seqno);
            }
            if (sender.equals(this.local_addr)) {
                if (Trace.trace) {
                    Trace.info("NAKACK.stable()", "removing [" + this.deleted_up_to + " - " + seqno + "] from sent_msgs");
                }
                for (long j = this.deleted_up_to; j <= seqno; ++j) {
                    this.sent_msgs.remove(new Long(j));
                }
                this.deleted_up_to = seqno;
            }
            if (recv_win == null) continue;
            recv_win.stable(seqno);
        }
    }

    public synchronized void retransmit(long first_seqno, long last_seqno, Address sender) {
        Message retransmit_msg = new Message(sender, null, null);
        if (Trace.trace) {
            Trace.info("NAKACK.retransmit()", "sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + sender);
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno);
        retransmit_msg.putHeader("NAKACK", hdr);
        this.passDown(new Event(1, retransmit_msg));
    }

    void clear() {
        this.sent_msgs.clear();
        Enumeration e = this.received_msgs.elements();
        while (e.hasMoreElements()) {
            NakReceiverWindow win = (NakReceiverWindow)e.nextElement();
            win.reset();
        }
        this.received_msgs.clear();
    }

    void removeAll() {
        this.sent_msgs.clear();
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(key);
            win.destroy();
        }
        this.received_msgs.clear();
    }

    String dumpContents() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nsent_msgs: " + this.sent_msgs.size());
        ret.append("\nreceived_msgs: ");
        Enumeration e = this.received_msgs.keys();
        while (e.hasMoreElements()) {
            Address key = (Address)e.nextElement();
            NakReceiverWindow w = (NakReceiverWindow)this.received_msgs.get(key);
            ret.append("\n" + w.toString());
        }
        return ret.toString();
    }

    String printSentMsgs() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.sent_msgs.keys();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement() + " ");
        }
        return sb.toString();
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.max_xmit_size = ((Integer)map.get("frag_size")).intValue();
            if (Trace.trace) {
                Trace.info("NAKACK.handleConfigEvent()", "max_xmit_size=" + this.max_xmit_size);
            }
        }
    }
}

