/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.log.Trace;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.Queue;
import org.jgroups.util.Util;

public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    RetransmitCommand retransmit_command = null;
    HashMap msgs = new HashMap();
    long[] interval = new long[]{1000L, 2000L, 3000L, 4000L};
    Retransmitter retransmitter = new Retransmitter(null, this);
    Queue msg_queue = new Queue();
    int window_size = -1;
    int min_threshold = -1;
    boolean use_sliding_window = false;
    boolean queueing = false;
    Protocol transport = null;

    public AckSenderWindow(RetransmitCommand com) {
        this.retransmit_command = com;
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, long[] interval) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, long[] interval, Protocol transport) {
        this.retransmit_command = com;
        this.interval = interval;
        this.transport = transport;
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public void setWindowSize(int window_size, int min_threshold) {
        this.window_size = window_size;
        this.min_threshold = min_threshold;
        if (min_threshold > window_size) {
            this.min_threshold = window_size;
            this.window_size = min_threshold;
            Trace.warn("AckSenderWindow.setWindowSize()", "min_threshold (" + min_threshold + ") has to be less than window_size ( " + window_size + "). Values are swapped");
        }
        if (this.window_size <= 0) {
            this.window_size = this.min_threshold > 0 ? (int)((double)this.min_threshold * 1.5) : 500;
            Trace.warn("AckSenderWindow.setWindowSize()", "window_size is <= 0, setting it to " + this.window_size);
        }
        if (this.min_threshold <= 0) {
            this.min_threshold = this.window_size > 0 ? (int)((double)this.window_size * 0.5) : 250;
            Trace.warn("AckSenderWindow.setWindowSize()", "min_threshold is <= 0, setting it to " + this.min_threshold);
        }
        if (Trace.trace) {
            Trace.info("AckSenderWindow.setWindowSize()", "window_size=" + this.window_size + ", min_threshold=" + this.min_threshold);
        }
        this.use_sliding_window = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            this.msgs.clear();
        }
        this.retransmitter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long seqno, Message msg) {
        Long tmp = new Long(seqno);
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            if (this.msgs.containsKey(tmp)) {
                return;
            }
            if (!this.use_sliding_window) {
                this.addMessage(seqno, tmp, msg);
            } else if (this.queueing) {
                this.addToQueue(seqno, msg);
            } else if (this.msgs.size() + 1 > this.window_size) {
                this.queueing = true;
                this.addToQueue(seqno, msg);
            } else {
                this.addMessage(seqno, tmp, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long seqno) {
        Long tmp = new Long(seqno);
        HashMap hashMap = this.msgs;
        synchronized (hashMap) {
            this.msgs.remove(tmp);
            this.retransmitter.remove(seqno);
            if (this.use_sliding_window && this.queueing && this.msgs.size() < this.min_threshold) {
                Entry entry;
                while (this.msgs.size() < this.window_size && (entry = this.removeFromQueue()) != null) {
                    this.addMessage(entry.seqno, new Long(entry.seqno), entry.msg);
                }
                if (this.msgs.size() + 1 > this.window_size) {
                    return;
                }
                this.queueing = false;
            }
        }
    }

    public String toString() {
        return this.msgs.keySet().toString() + " (retransmitter: " + this.retransmitter.toString() + ")";
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (this.retransmit_command != null) {
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg = (Message)this.msgs.get(new Long(i));
                if (msg == null) continue;
                this.retransmit_command.retransmit(i, msg);
            }
        }
    }

    void addMessage(long seqno, Long tmp, Message msg) {
        if (this.transport != null) {
            this.transport.passDown(new Event(1, msg));
        }
        this.msgs.put(tmp, msg);
        this.retransmitter.add(seqno, seqno);
    }

    void addToQueue(long seqno, Message msg) {
        try {
            this.msg_queue.add(new Entry(seqno, msg));
        }
        catch (Exception ex) {
            Trace.error("AckSenderWindow.addToQueue()", "exception=" + ex);
        }
    }

    Entry removeFromQueue() {
        try {
            return this.msg_queue.size() == 0 ? null : (Entry)this.msg_queue.remove();
        }
        catch (Exception ex) {
            Trace.error("AckSenderWindow.removeFromQueue()", "exception=" + ex);
            return null;
        }
    }

    public static void main(String[] args) {
        int i;
        long[] xmit_timeouts = new long[]{1000L, 2000L, 3000L, 4000L};
        AckSenderWindow win = new AckSenderWindow(new Dummy(), xmit_timeouts);
        Trace.init();
        int NUM = 1000;
        for (i = 1; i < 1000; ++i) {
            win.add(i, new Message());
        }
        System.out.println(win);
        Util.sleep(5000L);
        for (i = 1; i < 1000; ++i) {
            if (i % 2 != 0) continue;
            win.ack(i);
        }
        System.out.println(win);
        Util.sleep(4000L);
        for (i = 1; i < 1000; ++i) {
            if (i % 2 == 0) continue;
            win.ack(i);
        }
        System.out.println(win);
        Util.sleep(4000L);
        System.out.println("--done--");
    }

    static class Dummy
    implements RetransmitCommand {
        long last_xmit_req = 0L;
        long curr_time;

        Dummy() {
        }

        public void retransmit(long seqno, Message msg) {
            if (Trace.trace) {
                Trace.info("Dummy.retransmit()", "seqno=" + seqno);
            }
            this.curr_time = System.currentTimeMillis();
        }
    }

    class Entry {
        long seqno;
        Message msg;

        Entry(long seqno, Message msg) {
            this.seqno = seqno;
            this.msg = msg;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);
    }
}

